/*
 * Decompiled with CFR 0.152.
 */
package com.senior.ui.ext.renderer;

import com.senior.ui.components.VButton;
import com.senior.ui.components.VCheckBox;
import com.senior.ui.components.VColorPicker;
import com.senior.ui.components.VComponent;
import com.senior.ui.components.VEditBox;
import com.senior.ui.components.VFile;
import com.senior.ui.components.VFileButton;
import com.senior.ui.components.VFrame;
import com.senior.ui.components.VGroupBox;
import com.senior.ui.components.VLabel;
import com.senior.ui.components.VLine;
import com.senior.ui.components.VPanel;
import com.senior.ui.components.VRepeater;
import com.senior.ui.components.VTabGroup;
import com.senior.ui.components.VTabSheet;
import com.senior.ui.components.VTextArea;
import com.senior.ui.components.VToolbar;
import com.senior.ui.components.VViewPort;
import com.senior.ui.components.VWindow;
import com.senior.ui.components.calendar.VCalendar;
import com.senior.ui.components.combo.VComboBox;
import com.senior.ui.components.grid.VScrollGrid;
import com.senior.ui.components.image.VImage;
import com.senior.ui.components.radio.VRadioButton;
import com.senior.ui.components.tree.VTree;
import com.senior.ui.core.ChangeNode;
import com.senior.ui.ext.IDefaultProperties;
import com.senior.ui.ext.renderer.ComponentDefaultProperties;
import java.util.HashMap;
import java.util.Map;

class DefaultPropertiesManager {
    private static volatile DefaultPropertiesManager instance;
    private static Map<Class<?>, DefaultPropertiesProcessor> processors;

    static {
        processors = new HashMap();
        ComponentDefaultProperties componentDefaultProperties = new ComponentDefaultProperties();
        DefaultPropertiesManager.registerDefaultProperties(VLabel.class, new DefaultPropertiesProcessor(componentDefaultProperties));
        DefaultPropertiesManager.registerDefaultProperties(VCheckBox.class, new DefaultPropertiesProcessor(componentDefaultProperties));
        DefaultPropertiesManager.registerDefaultProperties(VColorPicker.class, new DefaultPropertiesProcessor(componentDefaultProperties));
        DefaultPropertiesManager.registerDefaultProperties(VEditBox.class, new DefaultPropertiesProcessor(componentDefaultProperties));
        DefaultPropertiesManager.registerDefaultProperties(VButton.class, new DefaultPropertiesProcessor(componentDefaultProperties));
        DefaultPropertiesManager.registerDefaultProperties(VPanel.class, new DefaultPropertiesProcessor(componentDefaultProperties));
        DefaultPropertiesManager.registerDefaultProperties(VViewPort.class, new DefaultPropertiesProcessor(componentDefaultProperties));
        DefaultPropertiesManager.registerDefaultProperties(VWindow.class, new DefaultPropertiesProcessor(componentDefaultProperties));
        DefaultPropertiesManager.registerDefaultProperties(VComboBox.class, new DefaultPropertiesProcessor(componentDefaultProperties));
        DefaultPropertiesManager.registerDefaultProperties(VLine.class, new DefaultPropertiesProcessor(componentDefaultProperties));
        DefaultPropertiesManager.registerDefaultProperties(VTabGroup.class, new DefaultPropertiesProcessor(componentDefaultProperties));
        DefaultPropertiesManager.registerDefaultProperties(VTabSheet.class, new DefaultPropertiesProcessor(componentDefaultProperties));
        DefaultPropertiesManager.registerDefaultProperties(VTextArea.class, new DefaultPropertiesProcessor(componentDefaultProperties));
        DefaultPropertiesManager.registerDefaultProperties(VImage.class, new DefaultPropertiesProcessor(componentDefaultProperties));
        DefaultPropertiesManager.registerDefaultProperties(VRadioButton.class, new DefaultPropertiesProcessor(componentDefaultProperties));
        DefaultPropertiesManager.registerDefaultProperties(VRepeater.class, new DefaultPropertiesProcessor(componentDefaultProperties));
        DefaultPropertiesManager.registerDefaultProperties(VTree.class, new DefaultPropertiesProcessor(componentDefaultProperties));
        DefaultPropertiesManager.registerDefaultProperties(VGroupBox.class, new DefaultPropertiesProcessor(componentDefaultProperties));
        DefaultPropertiesManager.registerDefaultProperties(VCalendar.class, new DefaultPropertiesProcessor(componentDefaultProperties));
        DefaultPropertiesManager.registerDefaultProperties(VScrollGrid.class, new DefaultPropertiesProcessor(componentDefaultProperties));
        DefaultPropertiesManager.registerDefaultProperties(VFrame.class, new DefaultPropertiesProcessor(componentDefaultProperties));
        DefaultPropertiesManager.registerDefaultProperties(VToolbar.class, new DefaultPropertiesProcessor(componentDefaultProperties));
        DefaultPropertiesManager.registerDefaultProperties(VFile.class, new DefaultPropertiesProcessor(componentDefaultProperties));
        DefaultPropertiesManager.registerDefaultProperties(VFileButton.class, new DefaultPropertiesProcessor(componentDefaultProperties));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DefaultPropertiesManager getInstance() {
        if (instance != null) return instance;
        Class<DefaultPropertiesManager> clazz = DefaultPropertiesManager.class;
        synchronized (DefaultPropertiesManager.class) {
            if (instance != null) return instance;
            instance = new DefaultPropertiesManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    static <T extends VComponent> void registerDefaultProperties(Class<T> componentClass, DefaultPropertiesProcessor defaultPropertiesProcessor) {
        processors.put(componentClass, defaultPropertiesProcessor);
    }

    private DefaultPropertiesManager() {
    }

    public <T extends VComponent> void clearDefaultProperties(T component, ChangeNode node) {
        if (component == null) {
            throw new IllegalStateException("Component can not be null");
        }
        if (node == null) {
            throw new IllegalStateException("ChangeNode can not be null");
        }
        DefaultPropertiesProcessor processor = processors.get(component.getClass());
        assert (processor != null);
        processor.clearDefaultProperties(component, node);
    }

    private static class DefaultPropertiesProcessor {
        private final IDefaultProperties[] defaults;

        public DefaultPropertiesProcessor(IDefaultProperties ... defaultProperties) {
            assert (defaultProperties != null);
            this.defaults = defaultProperties;
        }

        public void clearDefaultProperties(VComponent component, ChangeNode node) {
            IDefaultProperties[] iDefaultPropertiesArray = this.defaults;
            int n = this.defaults.length;
            int n2 = 0;
            while (n2 < n) {
                IDefaultProperties defaultProperties = iDefaultPropertiesArray[n2];
                defaultProperties.clearDefaultProperties(component, node);
                ++n2;
            }
        }
    }
}

