/*
 * Decompiled with CFR 0.152.
 */
package com.senior.ui.ext.renderer;

import com.senior.ui.components.ComponentProperty;
import com.senior.ui.components.VComponent;
import com.senior.ui.components.layout.card.CardLayout;
import com.senior.ui.core.ChangeNode;
import com.senior.ui.ext.renderer.AbstractRender;
import com.senior.ui.ext.renderer.IComponentRenderer;
import com.senior.ui.ext.renderer.JSONUtility;
import com.senior.ui.ext.renderer.JsUtility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;

public class CompositeRenderer
extends AbstractRender {
    private static final Comparator<ChangeNode.ChangeNodeAssociation> NODE_COMPARATOR = new Comparator<ChangeNode.ChangeNodeAssociation>(){

        @Override
        public int compare(ChangeNode.ChangeNodeAssociation cn1, ChangeNode.ChangeNodeAssociation cn2) {
            VComponent component1 = cn1.getReferencedNode().getComponent();
            VComponent component2 = cn2.getReferencedNode().getComponent();
            return component1.getParent().getIndexAt(component1) - component2.getParent().getIndexAt(component2);
        }
    };

    @Override
    protected void render(ChangeNode node, JSONUtility util, IComponentRenderer renderer) {
        Collection childrenAssocs = node.getMultipleAssociations(ComponentProperty.CHILDREN);
        if (!childrenAssocs.isEmpty()) {
            Collection<ChangeNode.ChangeNodeAssociation> sortedChildrenAssocs = CompositeRenderer.optimizeChildrenAssocs(childrenAssocs);
            util.key("items").array();
            for (ChangeNode.ChangeNodeAssociation childAssoc : sortedChildrenAssocs) {
                ChangeNode child = childAssoc.getReferencedNode();
                child.setPropertyChanges(child.getComponent().getDefaultProperties());
                JSONUtility childUtil = JSONUtility.getInstance();
                childUtil.object();
                renderer.render(child, childUtil);
                childUtil.end();
                util.value(childUtil);
                if (childUtil.hasAfterScripts()) {
                    util.getAfterScripts().append(childUtil.getAfterScripts());
                }
                if (childUtil.hasBeforeScripts()) {
                    util.getBeforeScripts().append(childUtil.getBeforeScripts());
                }
                JSONUtility.release(childUtil);
                childAssoc.markAsRendered();
            }
            util.end();
        }
    }

    private static Collection<ChangeNode.ChangeNodeAssociation> optimizeChildrenAssocs(Collection<ChangeNode.ChangeNodeAssociation> childrenAssocs) {
        ArrayList<ChangeNode.ChangeNodeAssociation> sortedChildrenAssocs = new ArrayList<ChangeNode.ChangeNodeAssociation>(childrenAssocs.size());
        for (ChangeNode.ChangeNodeAssociation childAssoc : childrenAssocs) {
            if (childAssoc.getStatus() == ChangeNode.ChangeNodeAssociationStatus.REMOVED) continue;
            sortedChildrenAssocs.add(childAssoc);
            Collections.sort(sortedChildrenAssocs, NODE_COMPARATOR);
        }
        return sortedChildrenAssocs;
    }

    @Override
    protected final void update(ChangeNode node, JsUtility util, IComponentRenderer renderer) {
        if (!this.canUpdateChildren(node)) {
            return;
        }
        Collection childrenAssocs = node.getMultipleAssociations(ComponentProperty.CHILDREN);
        ChangeType changeType = ChangeType.NO_CHANGES;
        for (ChangeNode.ChangeNodeAssociation childAssoc : childrenAssocs) {
            ChangeNode childNode = childAssoc.getReferencedNode();
            VComponent childCmp = childNode.getComponent();
            switch (childAssoc.getStatus()) {
                case ADDED: {
                    childNode.setPropertyChanges(childCmp.getDefaultProperties());
                    JSONUtility childJson = JSONUtility.getInstance();
                    childJson.object();
                    renderer.render(childNode, childJson);
                    childJson.end();
                    if (childJson.hasBeforeScripts()) {
                        util.append(childJson.getBeforeScripts());
                    }
                    util.method("insert", childCmp.getParent().getIndexAt(childCmp), childJson);
                    changeType = ChangeType.CHANGE_ITEMS;
                    if (childJson.hasAfterScripts()) {
                        util.append(childJson.getAfterScripts());
                    }
                    JSONUtility.release(childJson);
                    break;
                }
                case REMOVED: {
                    util.method("remove", childCmp.getId(), true);
                    changeType = ChangeType.CHANGE_ITEMS;
                    this.markAsRendered(childAssoc);
                    break;
                }
                case RENDERED: {
                    if (childNode.hasPropertyChange(ComponentProperty.VISIBLE_STATE) && changeType.ordinal() < ChangeType.CHANGE_VISIBILITY.ordinal()) {
                        changeType = ChangeType.CHANGE_VISIBILITY;
                    } else if (childNode.hasPropertyChange(ComponentProperty.TEXT) && changeType.ordinal() < ChangeType.CHANGE_CONTENT.ordinal() && childNode.getComponent().isVisible()) {
                        changeType = ChangeType.CHANGE_CONTENT;
                    } else if ((childNode.hasPropertyChange(ComponentProperty.HEIGHT) || childNode.hasPropertyChange(ComponentProperty.WIDTH) || childNode.hasPropertyChange(ComponentProperty.ACTION_CONFIG)) && changeType.ordinal() < ChangeType.CHANGE_SIZE.ordinal() && childNode.getComponent().isVisible()) {
                        changeType = ChangeType.CHANGE_SIZE;
                    }
                    renderer.update(childNode, util);
                    break;
                }
                default: {
                    throw new IllegalStateException(childAssoc.getStatus().toString());
                }
            }
            childAssoc.markAsRendered();
        }
        if (changeType != ChangeType.NO_CHANGES) {
            node.clearPropertyChange(ComponentProperty.LAYOUT_CHANGED);
            util.objMethod("Ext.ux.senior.LayoutOrganizer", "enqueueLayout", node.getComponent().getId(), changeType.ordinal());
        }
    }

    private void markAsRendered(ChangeNode.ChangeNodeAssociation parentAssociation) {
        ChangeNode parentNode = parentAssociation.getReferencedNode();
        if (parentNode.getMultipleAssociationProperties().contains(ComponentProperty.CHILDREN)) {
            Collection associations = parentNode.getMultipleAssociations(ComponentProperty.CHILDREN);
            for (ChangeNode.ChangeNodeAssociation changeNodeAssociation : associations) {
                changeNodeAssociation.markAsRendered();
                this.markAsRendered(changeNodeAssociation);
            }
        }
    }

    protected boolean canUpdateChildren(ChangeNode node) {
        VComponent panel = node.getComponent();
        boolean isCurrentTab = true;
        if (panel.getParent() != null && panel.getParent().getLayout() instanceof CardLayout) {
            CardLayout cardLayout = (CardLayout)panel.getParent().getLayout();
            VComponent currentTab = panel.getParent().getChildAt(cardLayout.getCurrentTab());
            isCurrentTab = currentTab.equals((Object)panel);
        }
        return node.hasAssociationsChanges() && node.getComponent().getVisibleState() && isCurrentTab;
    }

    private static enum ChangeType {
        NO_CHANGES,
        CHANGE_CONTENT,
        CHANGE_SIZE,
        CHANGE_VISIBILITY,
        CHANGE_ITEMS;

    }
}

