/*
 * Decompiled with CFR 0.152.
 */
package com.senior.ui.ext.renderer;

import com.senior.ui.components.ComponentProperty;
import com.senior.ui.components.DataType;
import com.senior.ui.components.VComponent;
import com.senior.ui.components.VComposite;
import com.senior.ui.components.VEditBox;
import com.senior.ui.components.VPanel;
import com.senior.ui.components.VRepeater;
import com.senior.ui.components.VTabGroup;
import com.senior.ui.components.VTextArea;
import com.senior.ui.components.combo.VComboBox;
import com.senior.ui.components.grid.VScrollGrid;
import com.senior.ui.components.layout.ILayoutDefaultsSupport;
import com.senior.ui.components.layout.ILayoutDefinition;
import com.senior.ui.components.layout.ILayoutManager;
import com.senior.ui.components.layout.LayoutDefinitionBase;
import com.senior.ui.components.layout.form.FormLayoutDefinition;
import com.senior.ui.components.layout.grid.GridLayoutDefinition;
import org.apache.commons.lang.StringUtils;

public class ComponentRenderUtility {
    private static final String DEFAULT_PERCENT_SIZE = "100%";
    private static final String DEFAULT_FIXED_WIDTH = "290";
    private static final String DEFAULT_DATEFIELD_WIDTH = "93";

    public static boolean hasParentLayoutDefinition(VComponent cmp, ILayoutDefinition layoutDef) {
        return layoutDef == null && cmp.getParent() != null && cmp.getParent().getLayout() instanceof ILayoutDefaultsSupport;
    }

    public static ILayoutDefinition getLayoutDefinition(VComponent cmp) {
        ILayoutDefinition layoutDef = (ILayoutDefinition)cmp.get(ComponentProperty.LAYOUT_DEFINITION);
        if (ComponentRenderUtility.hasParentLayoutDefinition(cmp, layoutDef)) {
            ILayoutManager layout = cmp.getParent().getLayout();
            layoutDef = ((ILayoutDefaultsSupport)layout).getDefaultLayoutDefinition();
        }
        return layoutDef;
    }

    public static void setDefaultSizeWhereUndefined(VComponent cmp) {
        ILayoutDefinition layoutDef = ComponentRenderUtility.getLayoutDefinition(cmp);
        String width = cmp.getWidth();
        if (StringUtils.isBlank((String)width)) {
            if (layoutDef instanceof GridLayoutDefinition) {
                ComponentRenderUtility.setDefaultSizeForGridLayout(cmp);
            } else if (layoutDef == null || layoutDef instanceof FormLayoutDefinition) {
                ComponentRenderUtility.setDefaultSizeForFormLayout(cmp);
            }
        }
    }

    private static void setDefaultSizeForGridLayout(VComponent cmp) {
        if (cmp instanceof VScrollGrid) {
            VComposite parent = cmp.getParent();
            if (parent == null || parent.getChildCount() == 1) {
                cmp.setWidth(DEFAULT_PERCENT_SIZE);
                if (StringUtils.isBlank((String)cmp.getHeight())) {
                    cmp.setHeight(DEFAULT_PERCENT_SIZE);
                }
            }
        } else if (cmp instanceof VEditBox && ((VEditBox)cmp).getType() != DataType.TYPE_DATE || cmp instanceof VTextArea || cmp instanceof VComboBox) {
            cmp.setWidth(DEFAULT_PERCENT_SIZE);
        }
    }

    private static void setDefaultSizeForFormLayout(VComponent cmp) {
        String defaultWidth = null;
        if (cmp instanceof VEditBox && ((VEditBox)cmp).getType() == DataType.TYPE_DATE) {
            defaultWidth = DEFAULT_DATEFIELD_WIDTH;
        } else if (cmp instanceof VEditBox || cmp instanceof VComboBox || cmp instanceof VTextArea) {
            defaultWidth = DEFAULT_FIXED_WIDTH;
        } else if (cmp instanceof VPanel || cmp instanceof VScrollGrid || cmp instanceof VRepeater || cmp instanceof VTabGroup) {
            defaultWidth = DEFAULT_PERCENT_SIZE;
        }
        cmp.setWidth(defaultWidth);
    }

    public static int[] getOverriddenMargins(VComponent component, LayoutDefinitionBase def) {
        LayoutDefinitionBase parentDef;
        ILayoutManager parentLayout = component.getParent().getLayout();
        int top = Math.abs(def.getMarginTop());
        int right = Math.abs(def.getMarginRight());
        int bottom = Math.abs(def.getMarginBottom());
        int left = Math.abs(def.getMarginLeft());
        if (parentLayout != null && parentLayout instanceof ILayoutDefaultsSupport && (parentDef = ((ILayoutDefaultsSupport)parentLayout).getDefaultLayoutDefinition()) != null) {
            top = ComponentRenderUtility.mergeValues(def.getMarginTop(), parentDef.getMarginTop());
            right = ComponentRenderUtility.mergeValues(def.getMarginRight(), parentDef.getMarginRight());
            bottom = ComponentRenderUtility.mergeValues(def.getMarginBottom(), parentDef.getMarginBottom());
            left = ComponentRenderUtility.mergeValues(def.getMarginLeft(), parentDef.getMarginLeft());
        }
        return new int[]{top, right, bottom, left};
    }

    private static int mergeValues(int componentMargin, int parentMargin) {
        if (componentMargin <= -1) {
            return ComponentRenderUtility.absValue(parentMargin);
        }
        return ComponentRenderUtility.absValue(componentMargin);
    }

    private static int absValue(int value) {
        return value >= 0 ? value : 0;
    }
}

