/*
 * Decompiled with CFR 0.152.
 */
package com.senior.ui.ext.renderer;

import com.senior.ui.components.ComponentProperty;
import com.senior.ui.components.IFieldDataDescriptor;
import com.senior.ui.components.VComponent;
import com.senior.ui.components.combo.IOption;
import com.senior.ui.components.combo.VComboBox;
import com.senior.ui.core.ChangeNode;
import com.senior.ui.ext.renderer.AbstractRender;
import com.senior.ui.ext.renderer.ComponentRenderUtility;
import com.senior.ui.ext.renderer.IComponentRenderer;
import com.senior.ui.ext.renderer.JSONUtility;
import com.senior.ui.ext.renderer.JsUtility;
import java.util.Collection;
import java.util.Iterator;

class ComboBoxRender
extends AbstractRender {
    public ComboBoxRender() {
        this.properties.put(ComponentProperty.EMPTY_TEXT, "emptyText");
        this.properties.put(ComponentProperty.SELECTED_OPTION, "value");
        this.methods.put(ComponentProperty.EMPTY_TEXT, "setEmptyText");
    }

    @Override
    protected void render(ChangeNode node, JSONUtility util, IComponentRenderer renderer) {
        VComboBox combobox = (VComboBox)node.getComponent();
        ComponentRenderUtility.setDefaultSizeWhereUndefined((VComponent)combobox);
        node.clearPropertyChange(ComponentProperty.TEXT);
        if (node.hasPropertyChange(ComponentProperty.SELECTED_OPTION)) {
            node.clearPropertyChange(ComponentProperty.SELECTED_OPTION);
            IOption selected = (IOption)combobox.get(ComponentProperty.SELECTED_OPTION);
            if (selected != null) {
                util.key(this.propertyName(ComponentProperty.SELECTED_OPTION)).value(selected.getText());
                util.key("selectedIndex").objectValue(combobox.getSelectedIndex());
            }
        }
        Collection descs = (Collection)combobox.get(ComponentProperty.DATA_DESCRIPTION);
        assert (descs.size() == 2);
        Iterator descrFields = descs.iterator();
        descrFields.next();
        IFieldDataDescriptor fieldDataDescriptor = (IFieldDataDescriptor)descrFields.next();
        util.key("displayField").value(fieldDataDescriptor.getFieldName());
        util.key("typeAhead").value("true");
        util.key("mode").value("local");
        util.key("forceSelection").value(true);
        util.key("triggerAction").value("all");
        util.key("selectOnFocus").value("true");
        if (node.hasPropertyChange(ComponentProperty.AUTO_COMPLETE)) {
            node.clearPropertyChange(ComponentProperty.AUTO_COMPLETE);
            util.key("minChars").value(combobox.isAutoComplete() ? 0 : Integer.MAX_VALUE);
        }
    }

    @Override
    protected void update(ChangeNode node, JsUtility util, IComponentRenderer renderer) {
        node.clearPropertyChange(ComponentProperty.TEXT);
        VComboBox combobox = (VComboBox)node.getComponent();
        ComponentRenderUtility.setDefaultSizeWhereUndefined((VComponent)combobox);
        if (!node.hasPropertyChanges() || !combobox.getVisibleState()) {
            return;
        }
        if (node.hasPropertyChange(ComponentProperty.SELECTED_OPTION)) {
            node.clearPropertyChange(ComponentProperty.SELECTED_OPTION);
            IOption selected = combobox.getSelectedOption();
            util.method("setValue", selected == null ? "" : selected.getText());
        }
    }
}

