/*
 * Decompiled with CFR 0.152.
 */
package com.senior.ui.ext.renderer;

import com.senior.ui.components.ActionConfig;
import com.senior.ui.components.ComponentProperty;
import com.senior.ui.components.VButton;
import com.senior.ui.components.VComposite;
import com.senior.ui.components.VPanel;
import com.senior.ui.core.ChangeNode;
import com.senior.ui.ext.renderer.BaseButtonRender;
import com.senior.ui.ext.renderer.IComponentRenderer;
import com.senior.ui.ext.renderer.JSONUtility;
import com.senior.ui.ext.renderer.JsUtility;
import java.util.List;
import org.apache.commons.lang.StringUtils;

class ButtonRender
extends BaseButtonRender {
    public ButtonRender() {
        this.properties.put(ComponentProperty.ENABLE_TOGGLE, "enableToggle");
        this.properties.put(ComponentProperty.TOGGLE_GROUP, "toggleGroup");
        this.properties.put(ComponentProperty.PRESSED, "pressed");
        this.properties.put(ComponentProperty.ACCESS_KEY, "accessKey");
        this.properties.put(ComponentProperty.BLOCK_INTF, "blockIntf");
        this.methods.put(ComponentProperty.ENABLE_TOGGLE, "setEnableToggle");
        this.methods.put(ComponentProperty.TOGGLE_GROUP, "setToggleGroup");
        this.methods.put(ComponentProperty.PRESSED, "toggle");
    }

    @Override
    protected void render(ChangeNode node, JSONUtility util, IComponentRenderer renderer) {
        char o;
        super.render(node, util, renderer);
        VButton button = (VButton)node.getComponent();
        if (node.hasPropertyChange(ComponentProperty.ACCESS_KEY) && (o = ((Character)button.get(ComponentProperty.ACCESS_KEY)).charValue()) == '\u0000') {
            node.clearPropertyChange(ComponentProperty.ACCESS_KEY);
        }
        VComposite controler = button.getParent();
        while (controler != null && !(controler instanceof VPanel)) {
            controler = controler.getParent();
        }
        if (controler != null) {
            util.key("accessKeyControler").value(controler.getId());
        }
        if (node.hasPropertyChange(ComponentProperty.ACTION_CONFIG)) {
            node.clearPropertyChange(ComponentProperty.ACTION_CONFIG);
            List acts = button.getActions();
            util.key("menu").object();
            ButtonRender.renderActionConfig(acts, util);
            util.end();
        }
    }

    @Override
    protected void update(ChangeNode node, JsUtility util, IComponentRenderer renderer) {
        VButton button = (VButton)node.getComponent();
        if (!node.hasPropertyChanges() || !button.getVisibleState()) {
            return;
        }
        super.update(node, util, renderer);
        if (node.hasPropertyChange(ComponentProperty.ACTION_CONFIG)) {
            node.clearPropertyChange(ComponentProperty.ACTION_CONFIG);
            JSONUtility rInnerUtil = JSONUtility.getInstance();
            rInnerUtil.object();
            ButtonRender.renderActionConfig(button.getActions(), rInnerUtil);
            rInnerUtil.end();
            util.method("updateMenuItems", rInnerUtil);
            JSONUtility.release(rInnerUtil);
        }
    }

    private static void renderActionConfig(List<ActionConfig> actions, JSONUtility util) {
        util.key("items").array();
        int i = 0;
        while (i < actions.size()) {
            char accessKey;
            ActionConfig action = actions.get(i);
            util.object();
            util.key("index").value(i);
            String label = action.getLabel();
            util.key("text").value(StringUtils.isEmpty((String)label) ? action.getName() : label);
            String icon = action.getCurrentIcon();
            if (icon != null && !"null".equals(icon)) {
                util.key("icon").value(ButtonRender.getResourceUri(icon));
            }
            if ((accessKey = action.getAccessKey()) != '\u0000') {
                util.key("accessKey").value(Character.valueOf(accessKey));
            }
            util.key("disabled").value(!action.isEnabled());
            util.end();
            ++i;
        }
        util.end();
    }
}

