/*
 * Decompiled with CFR 0.152.
 */
package com.senior.ui.ext.renderer;

import com.senior.ui.components.ComponentProperty;
import com.senior.ui.components.IFocusableComponent;
import com.senior.ui.components.VComponent;
import com.senior.ui.components.VComposite;
import com.senior.ui.components.VEditBox;
import com.senior.ui.components.VLabel;
import com.senior.ui.components.VTextArea;
import com.senior.ui.components.combo.VComboBox;
import com.senior.ui.components.layout.ILayoutDefinition;
import com.senior.ui.components.layout.LayoutDefinitionBase;
import com.senior.ui.components.layout.NullLayoutDefinition;
import com.senior.ui.components.layout.border.BorderLayout;
import com.senior.ui.components.layout.border.BorderLayoutDefinition;
import com.senior.ui.components.layout.flow.FlowLayout;
import com.senior.ui.components.layout.flow.FlowLayoutDefinition;
import com.senior.ui.components.layout.form.FormLayoutDefinition;
import com.senior.ui.components.layout.grid.GridLayoutDefinition;
import com.senior.ui.core.ChangeNode;
import com.senior.ui.definition.BorderLayoutRegion;
import com.senior.ui.definition.HorizontalAlignment;
import com.senior.ui.definition.VerticalAlignment;
import com.senior.ui.ext.renderer.AbstractRender;
import com.senior.ui.ext.renderer.ComponentRenderUtility;
import com.senior.ui.ext.renderer.IComponentRenderer;
import com.senior.ui.ext.renderer.JSONUtility;
import com.senior.ui.ext.renderer.JsUtility;
import com.senior.ui.ext.renderer.RenderFactory;
import com.senior.ui.ext.renderer.RendererFlag;
import com.senior.ui.ext.style.CSSUtility;
import com.senior.ui.ext.style.DynamicCssGenerator;
import com.senior.ui.plugin.Plugin;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

class BasicRender
extends AbstractRender {
    public BasicRender() {
        this.properties.put(ComponentProperty.ID, "id");
        this.properties.put(ComponentProperty.ENABLED_STATE, "disabled");
        this.properties.put(ComponentProperty.WIDTH, "width");
        this.properties.put(ComponentProperty.VISIBLE_STATE, "hidden");
        this.properties.put(ComponentProperty.HEIGHT, "height");
        this.properties.put(ComponentProperty.ALLOW_COLLAPSE, "collapsible");
        this.properties.put(ComponentProperty.ALLOW_HIDE, "allowHide");
        this.properties.put(ComponentProperty.HINTS, "hints");
        this.properties.put(ComponentProperty.NAME, "name");
        this.properties.put(ComponentProperty.TAB_ORDER, "focusOrder");
        this.properties.put(ComponentProperty.FOCUS_GROUP, "focusGroup");
        this.properties.put(ComponentProperty.ALLOW_DRAG, "dragEnabled");
        this.properties.put(ComponentProperty.ALLOW_DROP, "dropEnabled");
        this.properties.put(ComponentProperty.DRAG_GROUPS, "dragGroups");
        this.properties.put(ComponentProperty.MODAL, "modal");
        this.properties.put(ComponentProperty.AUTO_SCROLL, "autoScroll");
        this.properties.put(ComponentProperty.STRETCH, "isStretch");
        this.properties.put(ComponentProperty.UPDATE_IMAGE, "updateImage");
        this.properties.put(ComponentProperty.COLUMN_COUNT, "columnCount");
        this.properties.put(ComponentProperty.TITLE, "title");
        this.properties.put(ComponentProperty.SHOW_BORDER, "border");
        this.properties.put(ComponentProperty.READ_ONLY, "readOnly");
        this.properties.put(ComponentProperty.ICON, "icon");
        this.properties.put(ComponentProperty.MAXIMIZABLE, "maximizable");
        this.properties.put(ComponentProperty.CLOSABLE, "closable");
        this.properties.put(ComponentProperty.X, "x");
        this.properties.put(ComponentProperty.Y, "y");
        this.properties.put(ComponentProperty.ALT_TEXT, "altText");
        this.properties.put(ComponentProperty.URL, "url");
        this.properties.put(ComponentProperty.BORDER_WIDTH, "borderWidth");
        this.properties.put(ComponentProperty.COLOR, "value");
        this.methods.put(ComponentProperty.VISIBLE_STATE, "setVisible");
        this.methods.put(ComponentProperty.ENABLED_STATE, "setDisabled");
        this.methods.put(ComponentProperty.WIDTH, "setWidth");
        this.methods.put(ComponentProperty.HEIGHT, "setHeight");
        this.methods.put(ComponentProperty.HINTS, "setHints");
        this.methods.put(ComponentProperty.NAME, "setName");
        this.methods.put(ComponentProperty.ALLOW_DRAG, "setAllowDrag");
        this.methods.put(ComponentProperty.ALLOW_DROP, "setAllowDrop");
        this.methods.put(ComponentProperty.DRAG_GROUPS, "setDragGroups");
        this.methods.put(ComponentProperty.CHANGED, "markChanged");
        this.methods.put(ComponentProperty.COLOR, "setValue");
        this.methods.put(ComponentProperty.TITLE, "setTitle");
        this.methods.put(ComponentProperty.COLUMN_COUNT, "updateColumnCount");
        this.methods.put(ComponentProperty.TEXT, "setText");
        this.methods.put(ComponentProperty.READ_ONLY, "setReadOnly");
        this.methods.put(ComponentProperty.DESCRIPTION, "setDescription");
        this.methods.put(ComponentProperty.ALT_TEXT, "updateAltText");
        this.methods.put(ComponentProperty.URL, "setUrl");
        this.methods.put(ComponentProperty.BORDER_WIDTH, "setBorderWidth");
        this.methods.put(ComponentProperty.TAB_ORDER, "setFocusOrder");
        this.methods.put(ComponentProperty.FOCUS_GROUP, "setFocusGroup");
    }

    @Override
    protected void render(ChangeNode node, JSONUtility utility, IComponentRenderer renderer) {
        String width;
        VComponent cmp = node.getComponent();
        BasicRender.renderLayout(cmp, node, utility);
        if (node.hasPropertyChange(ComponentProperty.ENABLED_STATE)) {
            node.clearPropertyChange(ComponentProperty.ENABLED_STATE);
            Boolean enabled = (Boolean)cmp.get(ComponentProperty.ENABLED_STATE);
            if (enabled != null && !(cmp instanceof VComposite)) {
                utility.key(this.propertyName(ComponentProperty.ENABLED_STATE)).objectValue(enabled == false);
            }
        }
        utility.addPlugin("seniortooltip");
        if (node.hasPropertyChange(ComponentProperty.HINTS)) {
            node.clearPropertyChange(ComponentProperty.HINTS);
            List hints = (List)cmp.get(ComponentProperty.HINTS);
            if (!hints.isEmpty()) {
                utility.key(this.propertyName(ComponentProperty.HINTS));
                BasicRender.renderHints(utility, hints);
            }
        }
        if (node.hasPropertyChange(ComponentProperty.HEIGHT) || node.hasPropertyChange(ComponentProperty.WIDTH)) {
            String height;
            width = cmp.get(ComponentProperty.WIDTH) == null ? "" : (String)cmp.get(ComponentProperty.WIDTH);
            String string = height = cmp.get(ComponentProperty.HEIGHT) == null ? "" : (String)cmp.get(ComponentProperty.HEIGHT);
            if (width.indexOf(37) > -1 || height.indexOf(37) > -1) {
                String anchor = "";
                if (width.indexOf(37) > -1) {
                    node.clearPropertyChange(ComponentProperty.WIDTH);
                    anchor = width.concat(" ");
                } else {
                    anchor = " ";
                }
                if (height.indexOf(37) > -1) {
                    node.clearPropertyChange(ComponentProperty.HEIGHT);
                    anchor = anchor.concat(height);
                }
                utility.key("anchor").value(anchor);
            }
        }
        if (node.hasPropertyChange(ComponentProperty.WIDTH)) {
            node.clearPropertyChange(ComponentProperty.WIDTH);
            String string = width = cmp.get(ComponentProperty.WIDTH) == null ? "" : (String)cmp.get(ComponentProperty.WIDTH);
            if (width.length() > 0) {
                utility.key(this.propertyName(ComponentProperty.WIDTH)).objectValue(width);
            }
        }
        if (node.hasPropertyChange(ComponentProperty.HEIGHT)) {
            String height;
            node.clearPropertyChange(ComponentProperty.HEIGHT);
            String string = height = cmp.get(ComponentProperty.HEIGHT) == null ? "" : (String)cmp.get(ComponentProperty.HEIGHT);
            if (height.length() > 0) {
                utility.key(this.propertyName(ComponentProperty.HEIGHT)).objectValue(height);
            }
        }
        if (node.hasPropertyChange(ComponentProperty.VISIBLE_STATE)) {
            node.clearPropertyChange(ComponentProperty.VISIBLE_STATE);
            Boolean visible = (Boolean)cmp.get(ComponentProperty.VISIBLE_STATE);
            if (visible != null) {
                utility.key(this.propertyName(ComponentProperty.VISIBLE_STATE)).objectValue(visible == false);
            }
        }
        if (node.hasPropertyChange(ComponentProperty.LABEL)) {
            BasicRender.renderLabelStyle(node, utility);
        }
        if (node.hasPropertyChange(ComponentProperty.DESCRIPTION)) {
            node.clearPropertyChange(ComponentProperty.DESCRIPTION);
            utility.key("description").value(cmp.get(ComponentProperty.DESCRIPTION));
        }
        this.renderResource(ComponentProperty.ICON, cmp, node, utility);
        BasicRender.renderDragDrop(cmp, node, utility);
        BasicRender.renderPlugins(node, utility);
        if (!RendererFlag.IGNORE_EVENTMANAGER_PLUGIN.hasFlag(node)) {
            utility.addPlugin("eventmanager");
        }
        if (!RendererFlag.IGNORE_FOCUS_PLUGIN.hasFlag(node)) {
            BasicRender.addFocusPlugin(utility, cmp);
        }
        if (node.hasPropertyChange(ComponentProperty.STYLE)) {
            BasicRender.renderStyle(cmp, utility);
            node.clearPropertyChange(ComponentProperty.STYLE);
        }
        if (this.hasMaskPlugin(cmp, node)) {
            utility.key("maskEnabled").value(this.hasMaskPluginEnabled(cmp));
            ComponentProperty unmaskedProperty = BasicRender.getUnmaskedProperty(cmp);
            if (node.hasPropertyChange(unmaskedProperty)) {
                node.clearPropertyChange(unmaskedProperty);
                utility.key("rawValue").value(cmp.get(unmaskedProperty));
            }
            if (node.hasPropertyChange(ComponentProperty.TEXT)) {
                node.clearPropertyChange(ComponentProperty.TEXT);
                String text = (String)cmp.get(ComponentProperty.TEXT);
                text = StringUtils.isEmpty((String)text) ? "" : text;
                utility.key("value").value(text);
                utility.key("text").value(text);
                utility.key("maskedValue").value(text);
            }
        } else if (node.hasPropertyChange(ComponentProperty.TEXT)) {
            node.clearPropertyChange(ComponentProperty.TEXT);
            String text = (String)cmp.get(ComponentProperty.TEXT);
            utility.key("text").value(StringUtils.isEmpty((String)text) ? "" : text);
        }
    }

    private static ComponentProperty getUnmaskedProperty(VComponent cmp) {
        if (cmp instanceof VEditBox || cmp instanceof VTextArea) {
            return ComponentProperty.RAW_TEXT;
        }
        if (cmp instanceof VComboBox) {
            return ComponentProperty.SELECTED_OPTION;
        }
        if (cmp instanceof VLabel) {
            return ComponentProperty.TEXT;
        }
        return null;
    }

    private static void renderLabelStyle(ChangeNode node, JSONUtility utility) {
        VLabel label;
        node.clearPropertyChange(ComponentProperty.LABEL);
        if (((Boolean)node.getComponent().get(ComponentProperty.HAS_LABEL)).booleanValue() && (label = (VLabel)node.getComponent().get(ComponentProperty.LABEL)) != null) {
            utility.key("fieldLabel").value(label.getText());
            String[] style = label.getStyle();
            if (style != null) {
                utility.key("cls").value(style);
            }
        }
    }

    private static void addFocusPlugin(JSONUtility utility, VComponent component) {
        if (!(component instanceof IFocusableComponent)) {
            return;
        }
        utility.addPlugin("componentfocusplugin");
    }

    private static void renderStyle(VComponent cmp, JSONUtility utility) {
        JSONUtility generateCss = JSONUtility.getInstance();
        Map<String, CSSUtility[]> generatedCssClasses = DynamicCssGenerator.generateCss(cmp.getStyle(), cmp.getClass().getName());
        BasicRender.renderClasses(generatedCssClasses, utility.getBeforeScripts(), generateCss);
        utility.key("customStyle").value(generateCss.toString());
        JSONUtility.release(generateCss);
    }

    private static void renderClasses(Map<String, CSSUtility[]> cssClasses, JsUtility utility, JSONUtility css) {
        ArrayList<String> generatedClassesNames = new ArrayList<String>();
        css.array();
        for (Map.Entry<String, CSSUtility[]> entry : cssClasses.entrySet()) {
            CSSUtility[] cSSUtilityArray = entry.getValue();
            int n = cSSUtilityArray.length;
            int n2 = 0;
            while (n2 < n) {
                CSSUtility cssClass = cSSUtilityArray[n2];
                utility.addDynamicCSS(cssClass.toString());
                generatedClassesNames.add(cssClass.getName());
                ++n2;
            }
            css.object();
            css.key("scope").value(entry.getKey());
            css.key("cls").value(generatedClassesNames.toArray(new String[generatedClassesNames.size()]));
            css.end();
            generatedClassesNames.clear();
        }
        css.end();
    }

    private static void updateStyle(VComponent cmp, JsUtility utility) {
        JSONUtility generateCss = JSONUtility.getInstance();
        Map<String, CSSUtility[]> generatedCssClasses = DynamicCssGenerator.generateCss(cmp.getStyle(), cmp.getClass().getName());
        BasicRender.renderClasses(generatedCssClasses, utility, generateCss);
        utility.method("setStyle", generateCss.toString());
        JSONUtility.release(generateCss);
    }

    private static void renderLayout(VComponent cmp, ChangeNode node, JSONUtility utility) {
        node.clearPropertyChange(ComponentProperty.LAYOUT_DEFINITION);
        ILayoutDefinition layoutDef = ComponentRenderUtility.getLayoutDefinition(cmp);
        if (layoutDef instanceof BorderLayoutDefinition) {
            BasicRender.renderBorderLayoutDefinition(utility, cmp, (BorderLayoutDefinition)layoutDef);
        } else if (layoutDef instanceof GridLayoutDefinition) {
            BasicRender.renderGridLayoutDefinition(utility, (GridLayoutDefinition)layoutDef);
        } else if (layoutDef instanceof FormLayoutDefinition) {
            BasicRender.renderFormLayoutDefinition(utility, (FormLayoutDefinition)layoutDef);
        } else if (layoutDef instanceof NullLayoutDefinition) {
            BasicRender.renderNullLayoutDefinition(utility, (NullLayoutDefinition)layoutDef);
        } else if (layoutDef instanceof FlowLayoutDefinition && ComponentRenderUtility.hasParentLayoutDefinition(cmp, null) && ((FlowLayout)cmp.getParent().getLayout()).isWrapLine()) {
            FlowLayoutDefinition flowLayoutDef = (FlowLayoutDefinition)layoutDef;
            flowLayoutDef.setMarginTop(0);
            flowLayoutDef.setMarginBottom(0);
        }
        if (layoutDef != null) {
            BasicRender.renderMargin(utility, cmp, layoutDef);
        }
    }

    private static void renderFormLayoutDefinition(JSONUtility utility, FormLayoutDefinition layoutDef) {
        if (layoutDef != null) {
            utility.key("hideLabel").value(!layoutDef.isShowLabel());
        }
    }

    private static void renderMargin(JSONUtility utility, VComponent component, ILayoutDefinition layoutDef) {
        int[] margins = ComponentRenderUtility.getOverriddenMargins(component, (LayoutDefinitionBase)layoutDef);
        StringBuilder buf = new StringBuilder();
        buf.append(margins[0]).append("px ");
        buf.append(margins[1]).append("px ");
        buf.append(margins[2]).append("px ");
        buf.append(margins[3]).append("px");
        utility.key("margins").value(buf.toString());
    }

    private static void renderNullLayoutDefinition(JSONUtility utility, NullLayoutDefinition layoutDef) {
        utility.key("x").value(layoutDef.getX());
        utility.key("y").value(layoutDef.getY());
    }

    private static void renderGridLayoutDefinition(JSONUtility utility, GridLayoutDefinition layout) {
        if (layout != null) {
            int rowSpan = layout.getRowSpan();
            int colSpan = layout.getColSpan();
            if (rowSpan != 0) {
                utility.key("rowspan").value(rowSpan);
            }
            if (colSpan != 0) {
                utility.key("colspan").value(colSpan);
            }
            StringBuilder cellCls = new StringBuilder();
            VerticalAlignment verticalAlignment = layout.getVerticalAlignment();
            if (verticalAlignment != null && verticalAlignment != VerticalAlignment.NONE) {
                cellCls.append("ux-gridlayout-cell-verticalalign-").append(verticalAlignment.name().toLowerCase());
            }
            if (layout.getHorizontalAlignment() != null && layout.getHorizontalAlignment() != HorizontalAlignment.NONE) {
                cellCls.append(" ux-gridlayout-cell-horizontal-").append(layout.getHorizontalAlignment().name().toLowerCase());
            }
            String trim = cellCls.toString().trim();
            utility.key("cellCls").value(trim);
            utility.key("cls").value(trim);
        }
    }

    private static void renderBorderLayoutDefinition(JSONUtility utility, VComponent cmp, BorderLayoutDefinition layoutDef) {
        BorderLayoutRegion region = layoutDef.getRegion();
        utility.key("region").value(region.name().toLowerCase());
        utility.key("autoHide").objectValue(false);
        BorderLayout layout = (BorderLayout)cmp.getParent().getLayout();
        utility.key("split").objectValue(layout.isShowSplit(region));
    }

    private static void renderDragDrop(VComponent cmp, ChangeNode node, JSONUtility utility) {
        boolean allowDrop;
        boolean allowDrag = node.hasPropertyChange(ComponentProperty.ALLOW_DRAG) && cmp.isAllowDrag();
        boolean bl = allowDrop = node.hasPropertyChange(ComponentProperty.ALLOW_DROP) && cmp.isAllowDrop();
        if (allowDrag || allowDrop) {
            utility.addPlugin("dragdrop");
            if (allowDrag && node.hasPropertyChange(ComponentProperty.DRAG_GROUPS) && cmp.getDragGroups() != null && cmp.getDragGroups().size() > 0) {
                utility.key("dragGroups").array();
                for (String valor : cmp.getDragGroups()) {
                    utility.value(valor);
                }
                utility.end();
            }
            if (allowDrop && node.hasPropertyChange(ComponentProperty.DROP_GROUPS)) {
                node.clearPropertyChange(ComponentProperty.DROP_GROUPS);
                if (cmp.getDropGroups() != null && cmp.getDropGroups().size() > 0) {
                    utility.key("dropGroups").array();
                    for (String valor : cmp.getDropGroups()) {
                        utility.value(valor);
                    }
                    utility.end();
                }
            }
        }
    }

    private static void renderPlugins(ChangeNode node, JSONUtility util) {
        if (node.hasPropertyChange(ComponentProperty.PLUGIN)) {
            node.clearPropertyChange(ComponentProperty.PLUGIN);
            VComponent cmp = node.getComponent();
            for (Plugin p : cmp.getPlugins()) {
                RenderFactory.getPluginRender(p).configurePlugin(node, p, util);
            }
        }
    }

    @Override
    protected void update(ChangeNode node, JsUtility utility, IComponentRenderer renderer) {
        if (!node.hasPropertyChanges()) {
            return;
        }
        VComponent cmp = node.getComponent();
        if (node.hasPropertyChange(ComponentProperty.VISIBLE_STATE)) {
            if (cmp.getVisibleState()) {
                utility.method("show", new Object[0]);
            } else {
                utility.method("hide", new Object[0]);
            }
            node.clearPropertyChange(ComponentProperty.VISIBLE_STATE);
            Boolean visible = cmp.getVisibleState();
            utility.method(this.methodName(ComponentProperty.VISIBLE_STATE), visible);
        }
        if (!cmp.getVisibleState()) {
            return;
        }
        if (node.hasPropertyChange(ComponentProperty.STYLE)) {
            BasicRender.updateStyle(cmp, utility);
            node.clearPropertyChange(ComponentProperty.STYLE);
        }
        if (node.hasPropertyChange(ComponentProperty.ENABLED_STATE)) {
            node.clearPropertyChange(ComponentProperty.ENABLED_STATE);
            if (!(cmp instanceof VComposite)) {
                utility.method(this.methodName(ComponentProperty.ENABLED_STATE), !cmp.getEnableState());
            }
        }
        if (node.hasPropertyChange(ComponentProperty.HINTS)) {
            node.clearPropertyChange(ComponentProperty.HINTS);
            if (cmp.getHints().isEmpty()) {
                utility.method("removeHints", new Object[0]);
            } else {
                JSONUtility rUtil = JSONUtility.getInstance();
                BasicRender.renderHints(rUtil, (List)cmp.get(ComponentProperty.HINTS));
                utility.method(this.methodName(ComponentProperty.HINTS), rUtil);
                JSONUtility.release(rUtil);
            }
        }
        if (node.hasPropertyChange(ComponentProperty.WIDTH)) {
            node.clearPropertyChange(ComponentProperty.WIDTH);
            Object width = cmp.get(ComponentProperty.WIDTH);
            if (width != null) {
                utility.method(this.methodName(ComponentProperty.WIDTH), BasicRender.convertSize(String.valueOf(width)));
            }
        }
        if (node.hasPropertyChange(ComponentProperty.HEIGHT)) {
            node.clearPropertyChange(ComponentProperty.HEIGHT);
            Object height = cmp.get(ComponentProperty.HEIGHT);
            if (height != null) {
                utility.method(this.methodName(ComponentProperty.HEIGHT), BasicRender.convertSize(String.valueOf(height)));
            }
        }
        if (this.hasMaskPlugin(cmp, node)) {
            ComponentProperty unmaskedProperty;
            boolean hasMaskPluginEnabled = this.hasMaskPluginEnabled(cmp);
            if (node.hasPropertyChange(ComponentProperty.ENABLED_STATE) || node.hasPropertyChange(ComponentProperty.READ_ONLY) || node.hasPropertyChange(ComponentProperty.MASK)) {
                utility.method("setMaskPluginEnabled", hasMaskPluginEnabled);
            }
            if (node.hasPropertyChange(unmaskedProperty = BasicRender.getUnmaskedProperty(cmp)) || node.hasPropertyChange(ComponentProperty.TEXT)) {
                node.clearPropertyChange(ComponentProperty.TEXT);
                Object textValue = cmp.get(ComponentProperty.TEXT);
                if (hasMaskPluginEnabled) {
                    node.clearPropertyChange(unmaskedProperty);
                    utility.method("setValues", cmp.get(unmaskedProperty), textValue == null ? "" : textValue);
                } else {
                    utility.method("setValue", textValue == null ? "" : textValue);
                }
            }
        } else if (node.hasPropertyChange(ComponentProperty.TEXT)) {
            node.clearPropertyChange(ComponentProperty.TEXT);
            utility.method(this.methodName(ComponentProperty.TEXT), cmp.get(ComponentProperty.TEXT));
        }
        this.updateResource(ComponentProperty.ICON, cmp, node, utility);
        BasicRender.updatePlugins(node, utility);
    }

    private static final Object convertSize(String size) {
        Object ret = size.contains("%") ? String.valueOf(size) : Integer.valueOf(Integer.parseInt(size));
        return ret;
    }

    private static void updatePlugins(ChangeNode node, JsUtility util) {
        if (node.hasPropertyChange(ComponentProperty.PLUGIN)) {
            node.clearPropertyChange(ComponentProperty.PLUGIN);
            VComponent cmp = node.getComponent();
            for (Plugin p : cmp.getPlugins()) {
                RenderFactory.getPluginRender(p).renderAction(node, p, util);
            }
        }
    }
}

