/*
 * Decompiled with CFR 0.152.
 */
package com.senior.ui.ext.renderer;

import com.senior.mask.MaskType;
import com.senior.mask.Masks;
import com.senior.ui.components.ComponentProperty;
import com.senior.ui.components.DataType;
import com.senior.ui.components.Hint;
import com.senior.ui.components.IMaskable;
import com.senior.ui.components.VComponent;
import com.senior.ui.components.VEditBox;
import com.senior.ui.components.VEditable;
import com.senior.ui.components.VTextArea;
import com.senior.ui.core.ChangeNode;
import com.senior.ui.core.theme.StyleClass;
import com.senior.ui.core.theme.StyleEntry;
import com.senior.ui.core.theme.StyleScope;
import com.senior.ui.core.theme.ThemeDefinition;
import com.senior.ui.core.theme.ThemeManager;
import com.senior.ui.ext.CSSBuilder;
import com.senior.ui.ext.renderer.DefaultPropertiesManager;
import com.senior.ui.ext.renderer.IComponentRenderer;
import com.senior.ui.ext.renderer.JSONUtility;
import com.senior.ui.ext.renderer.JsUtility;
import com.senior.ui.ext.renderer.RendererFlag;
import com.senior.ui.ext.style.CSSUtility;
import com.senior.ui.util.UriUtil;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

abstract class AbstractRender {
    protected final Map<ComponentProperty, String> properties = new EnumMap<ComponentProperty, String>(ComponentProperty.class);
    protected final Map<ComponentProperty, String> methods = new EnumMap<ComponentProperty, String>(ComponentProperty.class);

    AbstractRender() {
    }

    public final void iRender(ChangeNode node, JSONUtility util, IComponentRenderer renderer) {
        AbstractRender.clearDefaultProperties(node);
        this.render(node, util, renderer);
        this.renderAllProperties(node, util);
    }

    public final void iUpdate(ChangeNode node, JsUtility util, IComponentRenderer renderer) {
        this.update(node, util, renderer);
        this.updateAllProperties(node, util);
    }

    protected void render(ChangeNode node, JSONUtility util, IComponentRenderer renderer) {
    }

    protected void update(ChangeNode node, JsUtility util, IComponentRenderer renderer) {
    }

    protected Object getComponentPropertyToRender(VComponent component, ComponentProperty property) {
        return component.get(property);
    }

    protected final String propertyName(ComponentProperty prop) {
        return this.properties.get(prop);
    }

    protected final String methodName(ComponentProperty prop) {
        return this.methods.get(prop);
    }

    private void renderAllProperties(ChangeNode node, JSONUtility utility) {
        for (ComponentProperty property : this.properties.keySet()) {
            if (!node.hasPropertyChange(property)) continue;
            node.clearPropertyChange(property);
            Object value = this.getComponentPropertyToRender(node.getComponent(), property);
            utility.key(this.propertyName(property)).value(value);
        }
    }

    private void updateAllProperties(ChangeNode node, JsUtility utility) {
        if (!node.getComponent().getVisibleState()) {
            return;
        }
        for (ComponentProperty methodProperty : this.methods.keySet()) {
            if (!node.hasPropertyChange(methodProperty)) continue;
            node.clearPropertyChange(methodProperty);
            Object value = this.getComponentPropertyToRender(node.getComponent(), methodProperty);
            utility.method(this.methodName(methodProperty), value);
        }
    }

    protected static final String[] buildCssClass(String[] styleClassesNames, EnumSet<StyleScope> filterScopes) {
        ThemeDefinition theme = ThemeManager.getInstance().getCurrentTheme();
        StyleClass styleClass = null;
        ArrayList<String> definitions = new ArrayList<String>();
        String[] stringArray = styleClassesNames;
        int n = styleClassesNames.length;
        int n2 = 0;
        while (n2 < n) {
            String styleClassName = stringArray[n2];
            styleClass = theme.getStyleClass(styleClassName);
            if (styleClass != null) {
                for (StyleEntry entry : styleClass.getEntries()) {
                    if (!filterScopes.contains(entry.getScope())) continue;
                    CSSUtility cssClass = CSSBuilder.generateCSSClass(styleClassName, styleClass.styleFor(entry.getScope(), entry.getProperty()), entry);
                    definitions.add(cssClass.toString());
                }
            }
            ++n2;
        }
        String[] cssClass = null;
        if (!definitions.isEmpty()) {
            String className = AbstractRender.buildStyleClassName(styleClassesNames, filterScopes);
            cssClass = new String[]{className, CSSBuilder.mergeCSSClasses(definitions.toArray(new String[definitions.size()]), className)};
            definitions.clear();
        }
        return cssClass;
    }

    private static String buildStyleClassName(String[] styleClasses, EnumSet<StyleScope> scopes) {
        StringBuilder builder = new StringBuilder();
        if (styleClasses != null && styleClasses.length > 0) {
            String[] stringArray = styleClasses;
            int n = styleClasses.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                builder.append(name);
                builder.append("-");
                ++n2;
            }
            for (StyleScope styleScope : scopes) {
                builder.append(styleScope.name().toLowerCase());
                builder.append("-");
            }
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }

    protected void renderResource(ComponentProperty type, VComponent cmp, ChangeNode node, JSONUtility utility) {
        if (node.hasPropertyChange(type)) {
            node.clearPropertyChange(type);
            Object cmpUri = this.getComponentPropertyToRender(cmp, type);
            String uri = null;
            if (cmpUri != null) {
                uri = AbstractRender.getResourceUri(String.valueOf(cmpUri));
            }
            utility.key(this.propertyName(type)).value(uri);
        }
    }

    protected void updateResource(ComponentProperty type, VComponent cmp, ChangeNode node, JsUtility utility) {
        if (node.hasPropertyChange(type)) {
            node.clearPropertyChange(type);
            Object cmpUri = this.getComponentPropertyToRender(cmp, type);
            String uri = null;
            if (cmpUri != null) {
                uri = AbstractRender.getResourceUri(String.valueOf(cmpUri));
            }
            utility.method(this.methodName(type), uri);
        }
    }

    protected static final String getResourceUri(String uri) {
        return UriUtil.getInstance().getResourceUri(uri);
    }

    private static void clearDefaultProperties(ChangeNode node) {
        DefaultPropertiesManager.getInstance().clearDefaultProperties(node.getComponent(), node);
    }

    protected boolean hasMaskPlugin(VComponent cmp, ChangeNode node) {
        boolean isEditBox = cmp instanceof VEditBox;
        boolean isDateOrTime = false;
        if (isEditBox) {
            VEditBox editBox = (VEditBox)cmp;
            boolean bl = isDateOrTime = editBox.getType() == DataType.TYPE_DATE;
            if (!isDateOrTime) {
                isDateOrTime = AbstractRender.isDateOrTime((IMaskable)editBox);
            }
        } else if (cmp instanceof VTextArea) {
            VTextArea textArea = (VTextArea)cmp;
            isDateOrTime = AbstractRender.isDateOrTime((IMaskable)textArea);
        }
        return (cmp instanceof VTextArea || cmp instanceof VEditBox) && !isDateOrTime && !RendererFlag.IGNORE_MASK_PLUGIN.hasFlag(node);
    }

    private static boolean isDateOrTime(IMaskable component) {
        boolean isDateOrTime = false;
        if (StringUtils.isNotEmpty((String)component.getMask())) {
            try {
                MaskType type = Masks.compile((String)component.getMask()).getType();
                isDateOrTime = type == MaskType.TIME || type == MaskType.DATE || type == MaskType.DATE_COMPETENCE;
            }
            catch (Exception exception) {
                isDateOrTime = false;
            }
        }
        return isDateOrTime;
    }

    protected void addMaskPlugin(JSONUtility utility, VComponent cmp) {
        utility.addPlugin("maskplugin");
    }

    protected boolean hasMaskPluginEnabled(VComponent cmp) {
        return ((VEditable)cmp).isEnabled() && !((VEditable)cmp).isReadOnly();
    }

    protected static void renderHints(JSONUtility utility, List<?> hints) {
        utility.array();
        for (Object object : hints) {
            Hint hint = (Hint)object;
            utility.object();
            utility.key("icon").value(hint.getIcon() != null ? AbstractRender.getResourceUri(hint.getIcon()) : null);
            String text = hint.getText();
            if (text != null) {
                text = text.replace("\n", "<br/>");
            }
            utility.key("text").value(text);
            utility.key("showDelay").value(hint.getShowDelay());
            utility.key("hideDelay").value(hint.getHideDelay());
            utility.key("dismissDelay").value(hint.getDismissDelay());
            utility.end();
        }
        utility.end();
    }
}

