/*
 * Decompiled with CFR 0.152.
 */
package com.senior.ui.ext;

import com.senior.ui.core.message.ContextMessage;
import com.senior.ui.core.message.Message;
import com.senior.ui.core.message.MessageFactory;
import com.senior.ui.ext.renderer.ConverterKeyCode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class XmlRequestProcessor
extends DefaultHandler {
    private static final String ASK_LATER_MSG_TYPE = "renderAction";
    private final StringBuilder valueBuffer = new StringBuilder();
    private String readProperty = null;
    private static final Logger LOGGER = Logger.getLogger(XmlRequestProcessor.class.getName());
    private ContextMessage message;
    private final List<Message> messages = new ArrayList<Message>();
    private boolean inRequest = false;
    private boolean inMsg = false;
    private boolean inProps = false;
    private XmlElement currentElement;
    private String perspectiveId;
    private String msgTarget;
    private String currentProp;
    private Map<String, Object> msgData = new HashMap<String, Object>();
    private final StringBuilder charactersBuffer = new StringBuilder();
    private static final String KEY = "key";

    static ContextMessage process(String data) {
        return new XmlRequestProcessor().processXml(data);
    }

    protected XmlRequestProcessor() {
    }

    protected ContextMessage processXml(String xmlData) {
        if (xmlData == null) {
            throw new IllegalStateException("Param xmlData cannot be null");
        }
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            saxParser.getXMLReader().setFeature("http://xml.org/sax/features/external-general-entities", false);
            saxParser.parse((InputStream)new ByteArrayInputStream(xmlData.getBytes()), (DefaultHandler)this);
        }
        catch (IOException e) {
            LOGGER.severe("IOException occurred, XXE may still possible: " + e.getMessage());
            throw new RuntimeException("IOException occurred when processing XML.");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        return this.message;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        this.currentElement = XmlElement.valueOf(qName.toUpperCase());
        this.check(this.currentElement);
        switch (this.currentElement) {
            case REQUEST: {
                this.inRequest = true;
                this.perspectiveId = attributes.getValue("perspectiveId");
                break;
            }
            case MESSAGE: {
                this.inMsg = true;
                this.msgTarget = attributes.getValue("target");
                break;
            }
            case ID: 
            case TYPE: {
                break;
            }
            case PROPERTIES: {
                this.inProps = true;
                break;
            }
            case PROP: {
                this.currentProp = attributes.getValue("name");
                this.msgData.put(this.currentProp, "");
                break;
            }
            default: {
                throw new RuntimeException("Invalid xml tag element!");
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.charactersBuffer.append(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        String value = this.charactersBuffer.toString();
        this.charactersBuffer.setLength(0);
        if (this.currentElement != null && value.length() > 0) {
            switch (this.currentElement) {
                case ID: {
                    this.msgData.put("id", value);
                    break;
                }
                case TYPE: {
                    this.msgData.put("type", value);
                    break;
                }
                case PROP: {
                    if (this.readProperty == null || !this.readProperty.equals(this.currentProp)) {
                        this.readProperty = this.currentProp;
                        this.valueBuffer.setLength(0);
                    }
                    if (this.currentProp.equalsIgnoreCase(KEY)) {
                        this.valueBuffer.append(ConverterKeyCode.convertToJava(Integer.parseInt(value)));
                    } else {
                        this.valueBuffer.append(value);
                    }
                    this.msgData.put(this.readProperty, this.valueBuffer.toString());
                    break;
                }
            }
        }
        XmlElement el = XmlElement.valueOf(qName.toUpperCase());
        switch (el) {
            case REQUEST: {
                this.message = new ContextMessage(this.perspectiveId, Collections.unmodifiableList(this.messages));
                this.endRequest();
                break;
            }
            case PROPERTIES: {
                this.inProps = false;
                break;
            }
            case MESSAGE: {
                if (this.isAskLaterMessage()) {
                    this.messages.add(MessageFactory.getMessage((String)this.msgTarget, this.msgData));
                }
                this.endMessage();
                break;
            }
        }
        this.check(el);
    }

    private boolean isAskLaterMessage() {
        return !ASK_LATER_MSG_TYPE.equals(this.msgData.get("type"));
    }

    private void endMessage() {
        this.currentElement = null;
        this.currentProp = null;
        this.msgData = new HashMap<String, Object>();
        this.msgTarget = null;
        this.inMsg = false;
        this.inProps = false;
    }

    private void endRequest() {
        this.currentElement = null;
        this.currentProp = null;
        this.msgData = null;
        this.msgTarget = null;
        this.inMsg = false;
        this.inProps = false;
        this.inRequest = false;
        this.perspectiveId = null;
        this.currentElement = null;
        this.currentProp = null;
    }

    private void check(XmlElement el) {
        if (this.inRequest) {
            if (this.inMsg) {
                if (this.inProps) {
                    if (el == XmlElement.PROP) {
                        return;
                    }
                } else {
                    switch (el) {
                        case ID: 
                        case TYPE: 
                        case PROPERTIES: {
                            return;
                        }
                    }
                }
            } else if (el == XmlElement.MESSAGE) {
                return;
            }
        } else if (el == XmlElement.REQUEST) {
            return;
        }
        throw new IllegalStateException("Invalid xmlData format!");
    }

    private static enum XmlElement {
        REQUEST,
        MESSAGE,
        ID,
        TYPE,
        PROPERTIES,
        PROP;

    }
}

