/*
 * Decompiled with CFR 0.152.
 */
package com.senior.ui.ext;

import com.senior.ui.core.theme.StyleProperty;
import com.senior.ui.core.theme.StyleScope;
import com.senior.ui.core.theme.ThemeDefinition;
import com.senior.ui.ext.ResourceColorChange;
import com.senior.ui.ext.ResourceCreatorManager;
import com.senior.ui.ext.ThemeToCssBuilder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class ThemeToCssSkeleton {
    private static final ThemeToCssBuilder instance = new ThemeToCssBuilder();
    private static String resourcesBaseURL;

    protected String styleFor(ThemeDefinition theme, StyleScope scope, StyleProperty property, String defaultValue) {
        String value = theme.styleFor(scope, property);
        return value != null ? value : defaultValue;
    }

    protected String formatBackground(String valueProperty) {
        if (valueProperty != null && valueProperty.startsWith("url")) {
            valueProperty = ResourceCreatorManager.getResourceCreator().formatUrl(valueProperty);
        }
        return valueProperty;
    }

    protected String generateResourceImage(StyleScope scope, StyleProperty property, String url, ResourceColorChange resourceColor) {
        return ResourceCreatorManager.getResourceCreator().createImage(scope, property, url, resourceColor, resourcesBaseURL);
    }

    protected String formatURL(String url) {
        return ResourceCreatorManager.getResourceCreator().formatUrl(url);
    }

    protected String getFontStyle(String value, boolean isImportant) {
        String[] styles;
        StringBuilder sb = new StringBuilder();
        boolean italic = false;
        boolean bold = false;
        String lineStyle = "none";
        String[] stringArray = styles = StringUtils.isEmpty((String)value) ? new String[]{} : value.split(" ");
        int n = styles.length;
        int n2 = 0;
        while (n2 < n) {
            String fontStyle = stringArray[n2];
            if ((fontStyle = fontStyle.trim()).equals("bold")) {
                bold = true;
            } else if (fontStyle.equals("italic")) {
                italic = true;
            } else if (fontStyle.equals("underline") || fontStyle.equals("overline") || fontStyle.equals("line-through")) {
                lineStyle = fontStyle;
            }
            ++n2;
        }
        sb.append("font-style: ").append(italic ? "italic" : "normal");
        ThemeToCssSkeleton.appendImportant(isImportant, sb);
        sb.append("font-weight: ").append(bold ? "bold" : "normal");
        ThemeToCssSkeleton.appendImportant(isImportant, sb);
        sb.append("text-decoration: ").append(lineStyle);
        ThemeToCssSkeleton.appendImportant(isImportant, sb);
        return sb.toString();
    }

    private static void appendImportant(boolean isImportant, StringBuilder sb) {
        if (isImportant) {
            sb.append("!important;\n");
        } else {
            sb.append(";\n");
        }
    }

    protected String formatColor(String value, String defaultValue) {
        if (value != null) {
            value = value.replace("#", "");
            Pattern pattern = Pattern.compile("[0-9A-F]{6}?");
            Matcher matcher = pattern.matcher(value);
            if (!matcher.matches()) {
                return defaultValue;
            }
            return value;
        }
        return defaultValue;
    }

    protected String getIcon(StyleScope scope, StyleProperty property, String value, String imageExtURL, ResourceColorChange imageExtColorChange) {
        if (value != null) {
            return value;
        }
        return this.generateResourceImage(scope, property, imageExtURL, imageExtColorChange);
    }

    public static String build(ThemeDefinition theme, String resourcesBaseUrl) {
        resourcesBaseURL = resourcesBaseUrl;
        return instance.generate(theme);
    }

    public String formatProcessIndicatorSize(String size, boolean blockIndicator) {
        int intSize = Integer.valueOf(size.replaceAll("px", ""));
        if (blockIndicator) {
            intSize = (int)((double)intSize * 1.5);
        }
        return String.valueOf(intSize).concat("px");
    }

    public static void main(String[] args) {
        int i = 1;
        char c = (char)(i + 48);
        System.out.println(c);
    }
}

