/*
 * Decompiled with CFR 0.152.
 */
package com.senior.ui.ext;

import com.senior.classloader.SeniortoolsClassLoader;
import com.senior.resource.DefaultResourceId;
import com.senior.resource.IResourceId;
import com.senior.resource.ResourceManager;
import com.senior.ui.core.HttpResourceManager;
import com.senior.ui.core.IHttpRequestDescriptor;
import com.senior.ui.core.theme.ThemeDefinition;
import com.senior.ui.core.theme.ThemeManager;
import com.senior.ui.ext.DesktopBuilder;
import com.senior.ui.ext.ExtIOProcessor;
import com.senior.ui.ext.ThemeToCssSkeleton;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.LocalDateTime;

public final class ExtResourceManager
extends HttpResourceManager {
    private static final String THEME_FINGERPRINT;
    private static final String THEME_CSS_FILE = "/theme.css";
    static final String FINGERPRINT;
    static final String BASE_RESOURCE_ID = "com.senior.ui.ext.theme=";
    static final String BASE_RESOURCE_IMAGE_ID = "com.senior.ui.ext.theme";
    private static final String IMAGES_PATH = "/images";
    private static final List<String> pathWhitelist;

    static {
        pathWhitelist = new ArrayList<String>();
        FINGERPRINT = "/".concat(Long.toString(ExtResourceManager.calculateFingerprint())).concat("/");
        THEME_FINGERPRINT = String.valueOf(System.currentTimeMillis());
        pathWhitelist.add("/adapter");
        pathWhitelist.add("/pkgs");
        pathWhitelist.add("/resources");
        pathWhitelist.add("/src/locale");
        pathWhitelist.add("/ext-all.js");
        pathWhitelist.add("/log");
    }

    private static boolean isJarFile(String file) {
        return file.startsWith("jar:file:/") || file.indexOf(".jar!") >= 0;
    }

    private static long calculateFingerprint() {
        String file = SeniortoolsClassLoader.getResource((String)ExtIOProcessor.class.getName().replace(".", "/").concat(".class")).getFile();
        long fingerprint = 0L;
        if (ExtResourceManager.isJarFile(file)) {
            file = file.replace("jar:file:/", "");
            file = file.replace("file:/", "");
            file = file.substring(0, file.indexOf(33));
            fingerprint = new File(file).lastModified();
        } else {
            long lastmodifiedJS;
            try {
                String filePath = URLDecoder.decode(SeniortoolsClassLoader.getResource((String)"com/senior/client/resources/ext3/js").getPath(), System.getProperty("file.encoding"));
                lastmodifiedJS = ExtResourceManager.findTheLatestFileDate(new File(filePath));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            fingerprint = lastmodifiedJS;
        }
        return fingerprint;
    }

    private static long findTheLatestFileDate(File diretory) {
        if (!diretory.exists()) {
            throw new IllegalArgumentException("File not found: " + diretory.getAbsolutePath());
        }
        return ExtResourceManager.findLastFile(diretory, 0L);
    }

    private static long findLastFile(File dir, long lastFile) {
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            lastFile = file.isFile() ? (file.lastModified() >= lastFile ? file.lastModified() : lastFile) : ExtResourceManager.findLastFile(file, lastFile);
            ++n2;
        }
        return lastFile;
    }

    private String removeFingerprint(String requestPath) {
        if (this.hasFingerprint(requestPath)) {
            requestPath = requestPath.replaceFirst(FINGERPRINT.substring(0, FINGERPRINT.length() - 1), "");
        }
        return requestPath;
    }

    private static String getCurrentThemeFingerprint() {
        LocalDateTime themeLastModification = ThemeManager.getInstance().getCurrentTheme().getLastModification();
        return String.valueOf(themeLastModification.toDateTime().getMillis());
    }

    public boolean hasFingerprint(String requestPath) {
        return FINGERPRINT != null && requestPath.startsWith(FINGERPRINT);
    }

    public InputStream getResourceInputStream(IHttpRequestDescriptor requestDesc) throws IOException {
        if ("/".equals(requestDesc.getRequestPath())) {
            try {
                ByteArrayInputStream ret = new ByteArrayInputStream(DesktopBuilder.build(requestDesc.getParametersMap(), FINGERPRINT, this.getThemeFingerprint()).getBytes(Charset.defaultCharset().name()));
                return ret;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        InputStream ret = this.getResourceInputStream(this.removeFingerprint(requestDesc.getRequestPath()));
        return ret;
    }

    public String getThemeFingerprint() {
        return THEME_FINGERPRINT.concat(ExtResourceManager.getCurrentThemeFingerprint());
    }

    public long getResourceModifiedDate(IHttpRequestDescriptor requestDesc) throws IOException {
        String resourcePath = this.removeFingerprint(requestDesc.getRequestPath());
        if (resourcePath.endsWith(THEME_CSS_FILE) || resourcePath.startsWith(IMAGES_PATH)) {
            return -1L;
        }
        URLConnection resourceConnection = this.getResourceConnection(resourcePath);
        if (resourceConnection == null) {
            throw new IOException("Resource not found");
        }
        return resourceConnection.getLastModified();
    }

    private InputStream getResourceInputStream(String filePath) throws IOException {
        if (filePath.endsWith(THEME_CSS_FILE)) {
            ThemeDefinition currentTheme = ThemeManager.getInstance().getCurrentTheme();
            IResourceId themeResourceId = ExtResourceManager.getThemeCSSResourceId(currentTheme.getName().concat(String.valueOf(currentTheme.getLastModification().toDateTime().getMillis())));
            String resourceURI = ResourceManager.getResourceURI((IResourceId)themeResourceId);
            if (resourceURI.isEmpty()) {
                String buildCss = ThemeToCssSkeleton.build(currentTheme, "../../../../");
                resourceURI = ResourceManager.createResource((IResourceId)themeResourceId, (InputStream)new ByteArrayInputStream(buildCss.getBytes()));
            }
            return ResourceManager.getResourceStream((String)resourceURI);
        }
        if (filePath.startsWith(IMAGES_PATH)) {
            String path = filePath.substring(IMAGES_PATH.length());
            InputStream resourceStream = ThemeManager.getInstance().getResourceStream(path);
            if (resourceStream == null) {
                throw new IOException("Resource not found: " + filePath);
            }
            return resourceStream;
        }
        return this.getResourceConnection(filePath).getInputStream();
    }

    private static IResourceId getThemeCSSResourceId(String themeName) {
        return new DefaultResourceId(BASE_RESOURCE_ID.concat(themeName));
    }

    private URLConnection getResourceConnection(String filePath) throws IOException {
        String defaultPath = "com/senior/client/resources/ext3/";
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource(defaultPath.concat(filePath).replace("//", "/"));
        if (url == null) {
            boolean allowedPath = false;
            for (String path : pathWhitelist) {
                if (!filePath.startsWith(path)) continue;
                allowedPath = true;
                break;
            }
            if (!allowedPath) {
                throw new IOException("Resource not found: " + filePath);
            }
            url = ((Object)((Object)this)).getClass().getClassLoader().getResource(filePath.substring(1));
        }
        if (url == null) {
            throw new RuntimeException("Resource not found: " + filePath);
        }
        URLConnection ret = url.openConnection();
        return ret;
    }
}

