/*
 * Decompiled with CFR 0.152.
 */
package com.senior.formcenter.auth;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class AuthErrorPageGenerator {
    private final List<Error> errors = new ArrayList<Error>();

    public void addError(String providerName, String msg) {
        this.errors.add(new Error(providerName, msg));
    }

    protected String writeMessage(String message) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html><head><title>Authentication Error </title></head><body><h1>Authentication Error</h1>");
        buffer.append("<script>\n");
        buffer.append("var doc = window.top.document");
        buffer.append("\ndoc.execCommand(\"ClearAuthenticationCache\");\n");
        buffer.append("</script>\n");
        buffer.append(message);
        buffer.append("</body></html>");
        return buffer.toString();
    }

    public String getPageHtml() {
        StringBuffer buffer = new StringBuffer();
        Iterator<Error> iterator = this.errors.iterator();
        while (iterator.hasNext()) {
            Error element;
            Error error = element = iterator.next();
            buffer.append("<p><b> Provider -  ").append(error.provider).append(": </b>").append(error.msg).append("</p>");
        }
        return this.writeMessage(buffer.toString());
    }

    public String getPageHtml(String message) {
        return this.writeMessage(message);
    }

    public List<Error> getErrors() {
        return this.errors;
    }

    public static class Error {
        String provider;
        String msg;

        public Error(String provider, String msg) {
            this.provider = provider;
            this.msg = msg;
        }

        public String getProvider() {
            return this.provider;
        }

        public String getMsg() {
            return this.msg;
        }
    }
}

