/*
 * Decompiled with CFR 0.152.
 */
package com.senior.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.senior.util.json.JsonUtils;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public final class JavascriptImportUtils {
    private static String[] jsSeniorAll;
    private static String[] jsSeniorDebug;
    private static String[] jsExtAll;
    private static String[] jsExtDebug;
    private static String[] jsSelenium;
    private static String[] jsLog;
    private static final String JS_JSON_FILE_PATH = "com/senior/client/resources/ext3/js/javascripts.json";

    static {
        try {
            JavascriptImportUtils.loadJavascripts();
        }
        catch (IOException e) {
            throw new RuntimeException("Resource not found in classpath: com/senior/resources/ext3/js/javascripts.json", e);
        }
    }

    private static void loadJavascripts() throws IOException {
        JsonObject json;
        URL resource = JavascriptImportUtils.class.getClassLoader().getResource(JS_JSON_FILE_PATH);
        Throwable throwable = null;
        Object var3_3 = null;
        try (InputStreamReader reader = new InputStreamReader(resource.openStream());){
            json = JsonUtils.parse((Reader)reader);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        jsSeniorAll = JavascriptImportUtils.loadJavascriptArray(json, "seniorAll");
        jsSeniorDebug = JavascriptImportUtils.loadJavascriptArray(json, "seniorDebug");
        jsExtAll = JavascriptImportUtils.loadJavascriptArray(json, "extAll");
        jsExtDebug = JavascriptImportUtils.loadJavascriptArray(json, "extDebug");
        jsSelenium = JavascriptImportUtils.loadJavascriptArray(json, "selenium");
        jsLog = JavascriptImportUtils.loadJavascriptArray(json, "log");
    }

    private static String[] loadJavascriptArray(JsonObject source, String key) {
        JsonArray jsonArray = source.get(key).getAsJsonArray();
        String[] files = new String[jsonArray.size()];
        int index = 0;
        while (index < jsonArray.size()) {
            files[index] = jsonArray.get(index).getAsString();
            ++index;
        }
        return files;
    }

    public static List<String> getAllJavascripts(int debugLevel, boolean seleniumScripts) {
        List<String> javascripts = JavascriptImportUtils.getExtJavascripts(debugLevel);
        javascripts.addAll(JavascriptImportUtils.getSeniorJavascripts(debugLevel, seleniumScripts));
        return javascripts;
    }

    public static List<String> getSeniorJavascripts(int debugLevel, boolean seleniumScripts) {
        if (debugLevel > 0) {
            if (seleniumScripts) {
                return JavascriptImportUtils.asList(jsSeniorDebug, jsLog, jsSelenium);
            }
            if (debugLevel > 1) {
                return JavascriptImportUtils.asList(jsSeniorDebug, jsLog);
            }
            return JavascriptImportUtils.asList(new String[][]{jsSeniorDebug});
        }
        if (seleniumScripts) {
            return JavascriptImportUtils.asList(jsSeniorAll, jsSelenium);
        }
        return JavascriptImportUtils.asList(new String[][]{jsSeniorAll});
    }

    public static List<String> getExtJavascripts(int debugLevel) {
        if (debugLevel > 0) {
            return JavascriptImportUtils.asList(new String[][]{jsExtDebug});
        }
        return JavascriptImportUtils.asList(new String[][]{jsExtAll});
    }

    private static List<String> asList(String[] ... arrays) {
        ArrayList<String> list = new ArrayList<String>();
        String[][] stringArray = arrays;
        int n = arrays.length;
        int n2 = 0;
        while (n2 < n) {
            String[] array;
            String[] stringArray2 = array = stringArray[n2];
            int n3 = array.length;
            int n4 = 0;
            while (n4 < n3) {
                String value = stringArray2[n4];
                list.add(value);
                ++n4;
            }
            ++n2;
        }
        return list;
    }
}

