/*
 * Decompiled with CFR 0.152.
 */
package cesium.utils;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;

public class ImageUtilities {
    public static BufferedImage getBufferedImage(String imageFile, Component c) {
        Image image = c.getToolkit().getImage(imageFile);
        ImageUtilities.waitForImage(image, c);
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(c), image.getHeight(c), 1);
        Graphics2D g2d = bufferedImage.createGraphics();
        g2d.drawImage(image, 0, 0, c);
        return bufferedImage;
    }

    public static BufferedImage getBufferedImage(byte[] data, Component c) {
        Image image = c.getToolkit().createImage(data);
        ImageUtilities.waitForImage(image, c);
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(c), image.getHeight(c), 1);
        Graphics2D g2d = bufferedImage.createGraphics();
        g2d.drawImage(image, 0, 0, c);
        return bufferedImage;
    }

    public static BufferedImage getBufferedImage(byte[] data) {
        ImageIcon icon = new ImageIcon(data);
        Image image = icon.getImage();
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        Graphics g = bufferedImage.getGraphics();
        g.drawImage(image, 0, 0, null);
        return bufferedImage;
    }

    public static boolean waitForImage(Image image, Component c) {
        MediaTracker tracker = new MediaTracker(c);
        tracker.addImage(image, 0);
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {}
        return !tracker.isErrorAny();
    }

    public static boolean waitForImages(Image[] images, Component c) {
        MediaTracker tracker = new MediaTracker(c);
        int i = 0;
        while (i < images.length) {
            tracker.addImage(images[i], 0);
            ++i;
        }
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {}
        return !tracker.isErrorAny();
    }
}

