/*
 * Decompiled with CFR 0.152.
 */
package cesium.utils;

import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelGrabber;

public final class ExtJSPixelGrabber
implements ImageObserver {
    private Image m_image;
    private Object m_pixels;
    private int m_iNumOfColors;
    private int m_iWidth;
    private int m_iHeight;
    private ColorModel m_colorModel;

    public ExtJSPixelGrabber(Image img) {
        this.m_image = img;
    }

    public void grabPixels() {
        this.m_iWidth = this.m_image.getWidth(this);
        this.m_iHeight = this.m_image.getHeight(this);
        PixelGrabber pixelGrabber = new PixelGrabber(this.m_image, 0, 0, this.m_iWidth, this.m_iHeight, true);
        try {
            pixelGrabber.grabPixels();
        }
        catch (Exception exception) {
            System.out.println("PixelGrabber exception");
        }
        this.m_pixels = pixelGrabber.getPixels();
        this.m_colorModel = pixelGrabber.getColorModel();
        if (this.m_colorModel instanceof IndexColorModel) {
            this.m_iNumOfColors = ((IndexColorModel)this.m_colorModel).getMapSize();
        }
    }

    public Object getPixels() {
        return this.m_pixels;
    }

    public int getWidth() {
        return this.m_iWidth;
    }

    public int getHeight() {
        return this.m_iHeight;
    }

    public int getNumOfColors() {
        return this.m_iNumOfColors;
    }

    public int getRed(int pixel) {
        if (this.m_colorModel instanceof IndexColorModel) {
            return ((IndexColorModel)this.m_colorModel).getRed(pixel);
        }
        return ((DirectColorModel)this.m_colorModel).getRed(pixel);
    }

    public int getGreen(int pixel) {
        if (this.m_colorModel instanceof IndexColorModel) {
            return ((IndexColorModel)this.m_colorModel).getGreen(pixel);
        }
        return ((DirectColorModel)this.m_colorModel).getGreen(pixel);
    }

    public int getBlue(int pixel) {
        if (this.m_colorModel instanceof IndexColorModel) {
            return ((IndexColorModel)this.m_colorModel).getBlue(pixel);
        }
        return ((DirectColorModel)this.m_colorModel).getBlue(pixel);
    }

    public int getAlpha(int pixel) {
        if (this.m_colorModel instanceof IndexColorModel) {
            return ((IndexColorModel)this.m_colorModel).getAlpha(pixel);
        }
        return ((DirectColorModel)this.m_colorModel).getAlpha(pixel);
    }

    public void destroy() {
        this.m_image = null;
        this.m_pixels = null;
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        return true;
    }
}

