/*
 * Decompiled with CFR 0.152.
 */
package cesium.processor;

import cesium.factory.ResourcesProcessorFactoryImpl;
import cesium.holder.PNGHolderImpl;
import cesium.holder.ResourcesHolder;
import cesium.holder.ThemeParametersHolder;
import cesium.op.ExtJSRescaleOp;
import cesium.op.ForegroundShiftOp;
import cesium.processor.AbstractImageProcessor;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.w3c.dom.Node;

public class PNGProcessorImpl
extends AbstractImageProcessor {
    public PNGProcessorImpl(ResourcesProcessorFactoryImpl resourcesProcessorFactory) {
        this.setResourcesProcessorFactory(resourcesProcessorFactory);
    }

    @Override
    public ResourcesHolder process(ResourcesHolder resHolder, ThemeParametersHolder themeParametersHolder, ExtJSRescaleOp brightenOp, ForegroundShiftOp foregroundOp, ExtJSRescaleOp liteOp, ExtJSRescaleOp bgOp, ExtJSRescaleOp fontOp, ExtJSRescaleOp transparencyOp, ExtJSRescaleOp borderOp, AffineTransformOp affineTransformOp, ExtJSRescaleOp headerFontOp, BufferedImageOp shadowTransparencyOp, ExtJSRescaleOp headerOp, ResourcesHolder toolsetSchemaHolder, String toolsetName, String familyHeaderFont, String weightHeaderFont, byte sizeHeaderFont, String familyFont, String weightFont, byte sizeFont, ResourcesHolder drawableSchemaHolder) {
        String resourcesPath = resHolder.getResourcesPath();
        boolean processingNotNeeded = resHolder.isProcessingNotNeeded();
        boolean isDrawable = resHolder.isDrawable();
        boolean isDrawableColorIndependent = resHolder.isDrawableColorIndependent();
        if (resourcesPath != null && processingNotNeeded && !isDrawable && !isDrawableColorIndependent) {
            return resHolder;
        }
        ResourcesHolder newResourcesHolder = super.process(resHolder, themeParametersHolder, brightenOp, foregroundOp, liteOp, bgOp, fontOp, transparencyOp, borderOp, affineTransformOp, headerFontOp, shadowTransparencyOp, headerOp, toolsetSchemaHolder, toolsetName, familyHeaderFont, weightHeaderFont, sizeHeaderFont, familyFont, weightFont, sizeFont, drawableSchemaHolder);
        PNGHolderImpl pngHolder = (PNGHolderImpl)resHolder;
        String path = pngHolder.getPath();
        ((PNGHolderImpl)newResourcesHolder).setPath(path);
        boolean isExternalToolset = pngHolder.isToolset() && toolsetName != null && !"".equals(toolsetName) && !"default".equals(toolsetName);
        ResourcesHolder resourceByPath = null;
        byte[] data = null;
        if (isExternalToolset) {
            String fileName = path.substring(path.lastIndexOf("/"));
            resourceByPath = toolsetSchemaHolder.findResourceByFileEnds("/" + toolsetName + fileName);
            data = resourceByPath != null ? (byte[])resourceByPath.getContent() : (byte[])resHolder.getContent();
        } else {
            data = (byte[])resHolder.getContent();
        }
        byte[] newData = null;
        BufferedImage image = null;
        try {
            ImageIO.setUseCache(false);
            byte[] drawableData = null;
            ByteArrayInputStream dis = null;
            BufferedImage drawableImage = null;
            boolean closeToBlack = foregroundOp.isCloseToBlack();
            if (isDrawable && closeToBlack || isDrawableColorIndependent) {
                String drawableFileName = path.substring(path.lastIndexOf("/"));
                ResourcesHolder drawableResource = drawableSchemaHolder.findResourceByFileEnds(drawableFileName);
                if (drawableResource != null) {
                    drawableData = (byte[])drawableResource.getContent();
                    dis = new ByteArrayInputStream(drawableData);
                    ImageReader drawableImageReader = ImageIO.getImageReadersBySuffix("png").next();
                    drawableImageReader.setInput(ImageIO.createImageInputStream(dis));
                    drawableImage = drawableImageReader.read(0);
                    drawableImageReader.getImageMetadata(0);
                } else {
                    drawableData = (byte[])resHolder.getContent();
                    throw new Exception("Drawable resource WEB_INF/resources_drawable/" + drawableFileName + " mapped but not found!");
                }
            }
            ((PNGHolderImpl)newResourcesHolder).setPath(path);
            ByteArrayInputStream is = new ByteArrayInputStream(data);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            MemoryCacheImageOutputStream mos = new MemoryCacheImageOutputStream(os);
            ImageReader imageReader = ImageIO.getImageReadersBySuffix("png").next();
            imageReader.setInput(ImageIO.createImageInputStream(is));
            ImageWriter imageWriter = ImageIO.getImageWritersByFormatName("png").next();
            imageWriter.setOutput(mos);
            image = imageReader.read(0);
            imageReader.getImageMetadata(0);
            IIOMetadata metadata = null;
            ImageWriteParam writeParam = null;
            writeParam = imageWriter.getDefaultWriteParam();
            if (resourceByPath == null || !isExternalToolset) {
                if (!processingNotNeeded && pngHolder.isWindow() && transparencyOp != null) {
                    image = transparencyOp.filter(image, image, borderOp.getOffsets(null), pngHolder.getBorderColor(), pngHolder.isBorderColor(), pngHolder.isWindow());
                }
                image = pngHolder.isHeader() ? headerOp.filter(image, image, borderOp.getOffsets(null), pngHolder.getBorderColor(), pngHolder.isBorderColor(), false) : (!pngHolder.isForeground() ? brightenOp.filter(image, image, borderOp.getOffsets(null), pngHolder.getBorderColor(), pngHolder.isBorderColor(), false) : liteOp.filter(image, image, borderOp.getOffsets(null), pngHolder.getBorderColor(), pngHolder.isBorderColor(), false));
                if (isDrawable && closeToBlack || isDrawableColorIndependent) {
                    image = foregroundOp.draw(image, drawableImage, (byte)16);
                }
            }
            ImageTypeSpecifier imageTypeSpecifier = new ImageTypeSpecifier(image);
            metadata = imageWriter.getDefaultImageMetadata(imageTypeSpecifier, writeParam);
            imageWriter.write(new IIOImage(image, null, metadata));
            mos.flush();
            imageWriter.dispose();
            mos.close();
            newData = os.toByteArray();
            os.flush();
            os.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (image != null) {
            newResourcesHolder.setContent(newData);
        }
        return newResourcesHolder;
    }

    private void configure(IIOMetadata metadata, String delayTime, int imageIndex) {
        String metaFormatName = metadata.getNativeMetadataFormatName();
        if (!"javax_imageio_png_1.0".equals(metaFormatName)) {
            throw new IllegalArgumentException("Unfamiliar png metadata format: " + metaFormatName);
        }
        IIOMetadataNode root = (IIOMetadataNode)metadata.getAsTree(metaFormatName);
        Node child = root.getFirstChild();
        while (child != null) {
            if ("GraphicControlExtension".equals(child.getNodeName())) break;
            child = child.getNextSibling();
        }
        if (child != null) {
            IIOMetadataNode gce = (IIOMetadataNode)child;
            gce.setAttribute("userInputFlag", "FALSE");
            gce.setAttribute("delayTime", delayTime);
        }
        if (imageIndex == 0) {
            IIOMetadataNode aes = new IIOMetadataNode("ApplicationExtensions");
            IIOMetadataNode ae = new IIOMetadataNode("ApplicationExtension");
            ae.setAttribute("applicationID", "CHENTSOV");
            ae.setAttribute("authenticationCode", "1.0");
            byte[] byArray = new byte[3];
            byArray[0] = 1;
            byte[] uo = byArray;
            ae.setUserObject(uo);
            aes.appendChild(ae);
            root.appendChild(aes);
        }
        try {
            metadata.setFromTree(metaFormatName, root);
        }
        catch (IIOInvalidTreeException e) {
            throw new Error(e);
        }
    }
}

