/*
 * Decompiled with CFR 0.152.
 */
package cesium.processor;

import cesium.factory.ResourcesProcessorFactoryImpl;
import cesium.holder.GIFHolderImpl;
import cesium.holder.ResourcesHolder;
import cesium.holder.ThemeParametersHolder;
import cesium.op.ExtJSRescaleOp;
import cesium.op.ForegroundShiftOp;
import cesium.processor.AbstractImageProcessor;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.w3c.dom.Node;

public class GIFProcessorImpl
extends AbstractImageProcessor {
    public GIFProcessorImpl(ResourcesProcessorFactoryImpl resourcesProcessorFactory) {
        this.setResourcesProcessorFactory(resourcesProcessorFactory);
    }

    @Override
    public ResourcesHolder process(ResourcesHolder resHolder, ThemeParametersHolder themeParametersHolder, ExtJSRescaleOp brightenOp, ForegroundShiftOp foregroundOp, ExtJSRescaleOp liteOp, ExtJSRescaleOp bgOp, ExtJSRescaleOp fontOp, ExtJSRescaleOp transparencyOp, ExtJSRescaleOp borderOp, AffineTransformOp affineTransformOp, ExtJSRescaleOp headerFontOp, BufferedImageOp shadowTransparencyOp, ExtJSRescaleOp headerOp, ResourcesHolder toolsetSchemaHolder, String toolsetName, String familyHeaderFont, String weightHeaderFont, byte sizeHeaderFont, String familyFont, String weightFont, byte sizeFont, ResourcesHolder drawableSchemaHolder) {
        byte[] data;
        String resourcesPath = resHolder.getResourcesPath();
        boolean isDrawable = resHolder.isDrawable();
        boolean isDrawableColorIndependent = resHolder.isDrawableColorIndependent();
        boolean processingNotNeeded = resHolder.isProcessingNotNeeded();
        if (resourcesPath != null && processingNotNeeded && !isDrawable && !isDrawableColorIndependent) {
            return resHolder;
        }
        ResourcesHolder newResourcesHolder = super.process(resHolder, themeParametersHolder, brightenOp, foregroundOp, liteOp, bgOp, fontOp, transparencyOp, borderOp, affineTransformOp, headerFontOp, shadowTransparencyOp, headerOp, toolsetSchemaHolder, toolsetName, familyHeaderFont, weightHeaderFont, sizeHeaderFont, familyFont, weightFont, sizeFont, drawableSchemaHolder);
        GIFHolderImpl gifOldHolder = (GIFHolderImpl)resHolder;
        String path = gifOldHolder.getPath();
        boolean isExternalToolset = gifOldHolder.isToolset() && toolsetName != null && !"".equals(toolsetName) && !"default".equals(toolsetName);
        ResourcesHolder resourceByPath = null;
        if (isExternalToolset) {
            String fileName = path.substring(path.lastIndexOf("/"));
            resourceByPath = toolsetSchemaHolder.findResourceByFileEnds("/" + toolsetName + fileName);
            data = resourceByPath != null ? (byte[])resourceByPath.getContent() : (byte[])resHolder.getContent();
        } else {
            data = (byte[])resHolder.getContent();
        }
        byte[] newData = null;
        BufferedImage image = null;
        try {
            ImageIO.setUseCache(false);
            byte[] drawableData = null;
            ByteArrayInputStream dis = null;
            BufferedImage drawableImage = null;
            boolean closeToBlack = foregroundOp.isCloseToBlack();
            if (isDrawable && closeToBlack || isDrawableColorIndependent) {
                String drawableFileName = path.substring(path.lastIndexOf("/"));
                ResourcesHolder drawableResource = drawableSchemaHolder.findResourceByFileEnds(drawableFileName);
                if (drawableResource != null) {
                    drawableData = (byte[])drawableResource.getContent();
                    dis = new ByteArrayInputStream(drawableData);
                    ImageReader drawableImageReader = ImageIO.getImageReadersBySuffix("gif").next();
                    drawableImageReader.setInput(ImageIO.createImageInputStream(dis));
                    drawableImage = drawableImageReader.read(0);
                } else {
                    drawableData = (byte[])resHolder.getContent();
                    throw new Exception("Drawable resource WEB_INF/resources_drawable/" + drawableFileName + " mapped but not found!");
                }
            }
            ((GIFHolderImpl)newResourcesHolder).setPath(path);
            ByteArrayInputStream is = new ByteArrayInputStream(data);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            MemoryCacheImageOutputStream mos = new MemoryCacheImageOutputStream(os);
            ImageReader imageReader = ImageIO.getImageReadersBySuffix("gif").next();
            imageReader.setInput(ImageIO.createImageInputStream(is));
            ImageWriter imageWriter = ImageIO.getImageWritersByFormatName("gif").next();
            imageWriter.setOutput(mos);
            int numImages = imageReader.getNumImages(true);
            IIOMetadata metadata = null;
            ImageWriteParam writeParam = null;
            if (numImages > 1) {
                writeParam = imageWriter.getDefaultWriteParam();
                IIOMetadata streamMetadata = imageReader.getStreamMetadata();
                imageWriter.prepareWriteSequence(streamMetadata);
            }
            int i = 0;
            while (i < numImages) {
                image = imageReader.read(i);
                if (resourceByPath == null || !isExternalToolset) {
                    if (!processingNotNeeded) {
                        image = gifOldHolder.isBackground() && bgOp != null ? bgOp.filter(image, image, borderOp.getOffsets(null), gifOldHolder.getBorderColor(), gifOldHolder.isBorderColor(), false) : (gifOldHolder.isHeader() ? headerOp.filter(image, image, borderOp.getOffsets(null), gifOldHolder.getBorderColor(), gifOldHolder.isBorderColor(), false) : (gifOldHolder.isWhitable() ? foregroundOp.filterToWhite(image, image) : (!gifOldHolder.isForeground() ? brightenOp.filter(image, image, borderOp.getOffsets(null), gifOldHolder.getBorderColor(), gifOldHolder.isBorderColor(), false) : liteOp.filter(image, image, borderOp.getOffsets(null), gifOldHolder.getBorderColor(), gifOldHolder.isBorderColor(), false))));
                    }
                    if (isDrawable && closeToBlack || isDrawableColorIndependent) {
                        image = foregroundOp.draw(image, drawableImage, (byte)16);
                    }
                }
                if (numImages > 1) {
                    ImageTypeSpecifier imageTypeSpecifier = new ImageTypeSpecifier(image);
                    metadata = imageWriter.getDefaultImageMetadata(imageTypeSpecifier, writeParam);
                    this.configure(metadata, "10", i);
                    imageWriter.writeToSequence(new IIOImage(image, null, metadata), null);
                } else {
                    imageWriter.write(image);
                }
                ++i;
            }
            if (numImages > 1) {
                imageWriter.endWriteSequence();
            }
            mos.flush();
            imageWriter.dispose();
            mos.close();
            newData = os.toByteArray();
            os.flush();
            os.close();
        }
        catch (IOException e) {
            System.out.println("Before IOException Path = " + path);
            e.printStackTrace();
        }
        catch (Exception e) {
            System.out.println("Before Exception Path = " + path);
            e.printStackTrace();
        }
        if (image != null) {
            newResourcesHolder.setContent(newData);
        }
        return newResourcesHolder;
    }

    private void configure(IIOMetadata metadata, String delayTime, int imageIndex) {
        String metaFormatName = metadata.getNativeMetadataFormatName();
        if (!"javax_imageio_gif_image_1.0".equals(metaFormatName)) {
            throw new IllegalArgumentException("Unfamiliar gif metadata format: " + metaFormatName);
        }
        IIOMetadataNode root = (IIOMetadataNode)metadata.getAsTree(metaFormatName);
        Node child = root.getFirstChild();
        while (child != null) {
            if ("GraphicControlExtension".equals(child.getNodeName())) break;
            child = child.getNextSibling();
        }
        if (child != null) {
            IIOMetadataNode gce = (IIOMetadataNode)child;
            gce.setAttribute("userInputFlag", "FALSE");
            gce.setAttribute("delayTime", delayTime);
        }
        if (imageIndex == 0) {
            IIOMetadataNode aes = new IIOMetadataNode("ApplicationExtensions");
            IIOMetadataNode ae = new IIOMetadataNode("ApplicationExtension");
            ae.setAttribute("applicationID", "CHENTSOV");
            ae.setAttribute("authenticationCode", "1.0");
            byte[] byArray = new byte[3];
            byArray[0] = 1;
            byte[] uo = byArray;
            ae.setUserObject(uo);
            aes.appendChild(ae);
            root.appendChild(aes);
            IIOMetadataNode ces = new IIOMetadataNode("CommentExtensions");
            IIOMetadataNode ce = new IIOMetadataNode("CommentExtension");
            ce.setAttribute("value", "GENERATED BY THEME BUILDER FOR EXTJS.AUTHOR:SERGEI CHENTSOV.");
            ces.appendChild(ce);
            root.appendChild(ces);
        }
        try {
            metadata.setFromTree(metaFormatName, root);
        }
        catch (IIOInvalidTreeException e) {
            throw new Error(e);
        }
    }
}

