/*
 * Decompiled with CFR 0.152.
 */
package cesium.processor;

import cesium.factory.ResourcesHolderFactoryImpl;
import cesium.factory.ResourcesProcessorFactoryImpl;
import cesium.holder.ResourcesHolder;
import cesium.holder.ThemeParametersHolder;
import cesium.op.ExtJSRescaleOp;
import cesium.op.ForegroundShiftOp;
import cesium.processor.ResourcesProcessor;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImageOp;

public abstract class AbstractResourcesProcessor
implements ResourcesProcessor {
    protected ResourcesProcessorFactoryImpl resourcesProcessorFactory;

    @Override
    public ResourcesProcessorFactoryImpl getResourcesProcessorFactory() {
        return this.resourcesProcessorFactory;
    }

    @Override
    public void setResourcesProcessorFactory(ResourcesProcessorFactoryImpl resourcesProcessorFactory) {
        this.resourcesProcessorFactory = resourcesProcessorFactory;
    }

    @Override
    public ResourcesHolder process(ResourcesHolder resHolder, ThemeParametersHolder themeParametersHolder, ExtJSRescaleOp brightenOp, ForegroundShiftOp foregroundOp, ExtJSRescaleOp liteOp, ExtJSRescaleOp bgOp, ExtJSRescaleOp fontOp, ExtJSRescaleOp transparencyOp, ExtJSRescaleOp borderOp, AffineTransformOp affineTransformOp, ExtJSRescaleOp headerFontOp, BufferedImageOp shadowTransparencyOp, ExtJSRescaleOp headerOp, ResourcesHolder toolsetSchemaHolder, String toolsetName, String familyHeaderFont, String weightHeaderFont, byte sizeHeaderFont, String familyFont, String weightFont, byte sizeFont, ResourcesHolder drawableSchemaHolder) {
        ResourcesHolderFactoryImpl factory = new ResourcesHolderFactoryImpl();
        ResourcesHolder holder = factory.getResourcesHolder(resHolder);
        Object content = resHolder.getContent();
        holder.setContent(content);
        String resourcesPath = resHolder.getResourcesPath();
        holder.setResourcesPath(resourcesPath);
        if (resHolder != null && !resHolder.isEmpty()) {
            for (Object key : resHolder.keySet()) {
                ResourcesHolder innerHolder = (ResourcesHolder)resHolder.get(key);
                ResourcesProcessor processor = this.resourcesProcessorFactory.getResourcesProcessor(innerHolder);
                if (processor == null || innerHolder == null) continue;
                ResourcesHolder newInnerHolder = processor.process(innerHolder, themeParametersHolder, brightenOp, foregroundOp, liteOp, bgOp, fontOp, transparencyOp, borderOp, affineTransformOp, headerFontOp, shadowTransparencyOp, headerOp, toolsetSchemaHolder, toolsetName, familyHeaderFont, weightHeaderFont, sizeHeaderFont, familyFont, weightFont, sizeFont, drawableSchemaHolder);
                holder.put(key, newInnerHolder);
            }
        }
        return holder;
    }

    @Override
    public ResourcesHolder advancedProcess(ResourcesHolder schemaHolder, BufferedImageOp brightenOp, BufferedImageOp foregroundOp, BufferedImageOp liteOp) {
        return null;
    }
}

