/*
 * Decompiled with CFR 0.152.
 */
package cesium.op;

import cesium.utils.GammaUtil;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class ShiftOp
implements BufferedImageOp {
    public static final int a_mask = -16777216;
    public static final int r_mask = 0xFF0000;
    public static final int g_mask = 65280;
    public static final int b_mask = 255;
    private boolean isSumMod256;
    float[] scaleFactors;
    float[] offsets;
    int length;

    public ShiftOp(float[] scaleFactors, float[] offsets, RenderingHints hints) {
        this.length = scaleFactors.length;
        if (this.length > offsets.length) {
            this.length = offsets.length;
        }
        this.scaleFactors = new float[this.length];
        this.offsets = new float[this.length];
        int i = 0;
        while (i < this.length) {
            this.scaleFactors[i] = scaleFactors[i];
            this.offsets[i] = offsets[i];
            ++i;
        }
    }

    public ShiftOp(float[] scaleFactors, float[] offsets, RenderingHints hints, boolean isSumMod256) {
        this(scaleFactors, offsets, hints);
        this.isSumMod256 = isSumMod256;
    }

    public ShiftOp(float scaleFactor, float offset, RenderingHints hints) {
        this.length = 1;
        this.scaleFactors = new float[1];
        this.offsets = new float[1];
        this.scaleFactors[0] = scaleFactor;
        this.offsets[0] = offset;
    }

    @Override
    public final BufferedImage filter(BufferedImage src, BufferedImage dst) {
        BufferedImage origDst = src;
        int width = src.getWidth();
        int height = src.getHeight();
        int x = 0;
        while (x < width) {
            int y = 0;
            while (y < height) {
                int newB;
                int newG;
                int newR;
                int newA;
                int oldRgb = src.getRGB(x, y);
                int oldA = (oldRgb & 0xFF000000) >> 24;
                int oldR = (oldRgb & 0xFF0000) >> 16;
                int oldG = (oldRgb & 0xFF00) >> 8;
                int oldB = oldRgb & 0xFF;
                if (this.isSumMod256) {
                    newA = GammaUtil.sumMod256(oldA, (int)this.offsets[3]);
                    newR = GammaUtil.sumMod256(oldR, (int)this.offsets[0]);
                    newG = GammaUtil.sumMod256(oldG, (int)this.offsets[1]);
                    newB = GammaUtil.sumMod256(oldB, (int)this.offsets[2]);
                } else {
                    newA = oldA;
                    newR = GammaUtil.sumMinMax(oldR, (int)this.offsets[0]);
                    newG = GammaUtil.sumMinMax(oldG, (int)this.offsets[1]);
                    newB = GammaUtil.sumMinMax(oldB, (int)this.offsets[2]);
                }
                int newRgb = newA << 24 & 0xFF000000 | newR << 16 & 0xFF0000 | newG << 8 & 0xFF00 | newB & 0xFF;
                src.setRGB(x, y, newRgb);
                ++y;
            }
            ++x;
        }
        return origDst;
    }

    @Override
    public Rectangle2D getBounds2D(BufferedImage src) {
        return null;
    }

    @Override
    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel destCM) {
        BufferedImage image;
        if (destCM == null) {
            ColorModel cm = src.getColorModel();
            image = new BufferedImage(cm, src.getRaster().createCompatibleWritableRaster(), cm.isAlphaPremultiplied(), null);
        } else {
            int w = src.getWidth();
            int h = src.getHeight();
            image = new BufferedImage(destCM, destCM.createCompatibleWritableRaster(w, h), destCM.isAlphaPremultiplied(), null);
        }
        return image;
    }

    @Override
    public Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        return null;
    }

    @Override
    public RenderingHints getRenderingHints() {
        return null;
    }

    public WritableRaster createCompatibleDestRaster(Raster src) {
        return src.createCompatibleWritableRaster(src.getWidth(), src.getHeight());
    }
}

