/*
 * Decompiled with CFR 0.152.
 */
package cesium.op;

import cesium.utils.GammaUtil;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;

public class ForegroundShiftOp
implements BufferedImageOp {
    public static final int a_mask = -16777216;
    public static final int r_mask = 0xFF0000;
    public static final int g_mask = 65280;
    public static final int b_mask = 255;
    private final int newR;
    private final int newG;
    private final int newB;

    public ForegroundShiftOp(int newR, int newG, int newB) {
        this.newR = newR;
        this.newG = newG;
        this.newB = newB;
    }

    @Override
    public BufferedImage filter(BufferedImage src, BufferedImage dest) {
        BufferedImage origDst = src;
        int width = src.getWidth();
        int height = src.getHeight();
        byte[] compsR = new byte[1];
        byte[] compsG = new byte[1];
        byte[] compsB = new byte[1];
        int x = 0;
        while (x < width) {
            int y = 0;
            while (y < height) {
                int oldRgb = src.getRGB(x, y);
                int oldAnotShifted = oldRgb & 0xFF000000;
                compsR[0] = (byte)((oldRgb & 0xFF0000) >> 16);
                compsG[0] = (byte)((oldRgb & 0xFF00) >> 8);
                compsB[0] = (byte)(oldRgb & 0xFF);
                this.rescale(compsR, compsG, compsB);
                int newRgb = oldAnotShifted | compsR[0] << 16 & 0xFF0000 | compsG[0] << 8 & 0xFF00 | compsB[0] & 0xFF;
                src.setRGB(x, y, newRgb);
                ++y;
            }
            ++x;
        }
        return origDst;
    }

    public BufferedImage filterToWhite(BufferedImage src, BufferedImage dest) {
        BufferedImage origDst = src;
        ColorModel colorModel = src.getColorModel();
        if (colorModel instanceof IndexColorModel) {
            IndexColorModel icm = (IndexColorModel)colorModel;
            int size = icm.getMapSize();
            byte[] reds = new byte[size];
            byte[] greens = new byte[size];
            byte[] blues = new byte[size];
            byte[] alphas = new byte[size];
            icm.getReds(reds);
            icm.getGreens(greens);
            icm.getBlues(blues);
            icm.getAlphas(alphas);
            this.rescaleToWhite(reds, greens, blues);
            IndexColorModel newIndexColorModel = new IndexColorModel(8, size, reds, greens, blues, alphas);
            origDst = new BufferedImage(newIndexColorModel, src.getRaster(), false, null);
        } else {
            int width = src.getWidth();
            int height = src.getHeight();
            byte[] compsR = new byte[1];
            byte[] compsG = new byte[1];
            byte[] compsB = new byte[1];
            int x = 0;
            while (x < width) {
                int y = 0;
                while (y < height) {
                    int oldRgb = src.getRGB(x, y);
                    int oldAnotShifted = oldRgb & 0xFF000000;
                    compsR[0] = (byte)((oldRgb & 0xFF0000) >> 16);
                    compsG[0] = (byte)((oldRgb & 0xFF00) >> 8);
                    compsB[0] = (byte)(oldRgb & 0xFF);
                    this.rescaleToWhite(compsR, compsG, compsB);
                    int newRgb = oldAnotShifted | compsR[0] << 16 & 0xFF0000 | compsG[0] << 8 & 0xFF00 | compsB[0] & 0xFF;
                    src.setRGB(x, y, newRgb);
                    ++y;
                }
                ++x;
            }
        }
        return origDst;
    }

    public void rescale(byte[] compsR, byte[] compsG, byte[] compsB) {
        int i = 0;
        while (i < compsR.length) {
            boolean newCloseToWhite;
            boolean oldCloseToWhite = GammaUtil.closeToWhite(compsR[i], compsG[i], compsB[i]);
            boolean invertNeeded = !(oldCloseToWhite ^ (newCloseToWhite = GammaUtil.closeToWhite(this.newR, this.newG, this.newB)));
            compsR[i] = (byte)(invertNeeded ? 255 - compsR[i] : compsR[i]);
            compsG[i] = (byte)(invertNeeded ? 255 - compsG[i] : compsG[i]);
            compsB[i] = (byte)(invertNeeded ? 255 - compsB[i] : compsB[i]);
            ++i;
        }
    }

    public void rescaleToWhite(byte[] compsR, byte[] compsG, byte[] compsB) {
        int i = 0;
        while (i < compsR.length) {
            boolean newCloseToWhite;
            boolean oldCloseToWhite = GammaUtil.closeToWhite(compsR[i], compsG[i], compsB[i]);
            boolean invertNeeded = !(oldCloseToWhite ^ (newCloseToWhite = GammaUtil.closeToWhite(this.newR, this.newG, this.newB)));
            compsR[i] = (byte)(invertNeeded ? 255 : compsR[i]);
            compsG[i] = (byte)(invertNeeded ? 255 : compsG[i]);
            compsB[i] = (byte)(invertNeeded ? 255 : compsB[i]);
            ++i;
        }
    }

    @Override
    public Rectangle2D getBounds2D(BufferedImage src) {
        return null;
    }

    @Override
    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel destCM) {
        return null;
    }

    @Override
    public Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        return null;
    }

    @Override
    public RenderingHints getRenderingHints() {
        return null;
    }

    public BufferedImage draw(BufferedImage image, BufferedImage drawableImage, byte nBits) {
        BufferedImage result = null;
        ColorModel colorModel = image.getColorModel();
        ColorModel colorModelForDrawable = drawableImage.getColorModel();
        if (colorModel instanceof IndexColorModel && colorModelForDrawable instanceof IndexColorModel) {
            IndexColorModel icm = (IndexColorModel)colorModel;
            IndexColorModel dicm = (IndexColorModel)colorModelForDrawable;
            int size = icm.getMapSize();
            int dsize = dicm.getMapSize();
            int resultsize = size + dsize;
            byte[] reds = new byte[size];
            byte[] greens = new byte[size];
            byte[] blues = new byte[size];
            byte[] alphas = new byte[size];
            byte[] dreds = new byte[dsize];
            byte[] dgreens = new byte[dsize];
            byte[] dblues = new byte[dsize];
            byte[] dalphas = new byte[dsize];
            byte[] resultreds = new byte[resultsize];
            byte[] resultgreens = new byte[resultsize];
            byte[] resultblues = new byte[resultsize];
            byte[] resultalphas = new byte[resultsize];
            icm.getReds(reds);
            icm.getGreens(greens);
            icm.getBlues(blues);
            icm.getAlphas(alphas);
            dicm.getReds(dreds);
            dicm.getGreens(dgreens);
            dicm.getBlues(dblues);
            dicm.getAlphas(dalphas);
            System.arraycopy(reds, 0, resultreds, 0, size);
            System.arraycopy(dreds, 0, resultreds, size, dsize);
            System.arraycopy(greens, 0, resultgreens, 0, size);
            System.arraycopy(dgreens, 0, resultgreens, size, dsize);
            System.arraycopy(blues, 0, resultblues, 0, size);
            System.arraycopy(dblues, 0, resultblues, size, dsize);
            System.arraycopy(alphas, 0, resultalphas, 0, size);
            System.arraycopy(dalphas, 0, resultalphas, size, dsize);
            IndexColorModel newIndexColorModel = null;
            WritableRaster raster = image.getRaster();
            WritableRaster draster = drawableImage.getRaster();
            int width = image.getWidth();
            int height = image.getHeight();
            newIndexColorModel = new IndexColorModel((int)nBits, resultsize, resultreds, resultgreens, resultblues, resultalphas);
            WritableRaster newRaster = newIndexColorModel.createCompatibleWritableRaster(width, height);
            int[] newIndex = new int[1];
            int y = 0;
            while (y < height) {
                int x = 0;
                while (x < width) {
                    int[] pixel = draster.getPixel(x, y, (int[])null);
                    int alphaIndex = pixel[0];
                    if (dalphas[alphaIndex] == -1) {
                        newIndex[0] = alphaIndex + size;
                        newRaster.setPixel(x, y, newIndex);
                    } else {
                        int[] ints = raster.getPixel(x, y, (int[])null);
                        newRaster.setPixel(x, y, ints);
                    }
                    ++x;
                }
                ++y;
            }
            result = new BufferedImage(newIndexColorModel, newRaster, false, null);
        }
        return result;
    }

    public boolean isCloseToBlack() {
        return !GammaUtil.closeToWhite(this.newR, this.newG, this.newB);
    }
}

