/*
 * Decompiled with CFR 0.152.
 */
package cesium.op;

import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ByteLookupTable;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.LookupOp;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.SampleModel;
import java.awt.image.ShortLookupTable;
import java.awt.image.WritableRaster;
import java.util.Arrays;

public class ExtJSRescaleOp
implements BufferedImageOp,
RasterOp {
    float[] scaleFactors;
    float[] offsets;
    int length;
    RenderingHints hints;
    private int srcNbits;
    private int dstNbits;
    float[] borderOffsets;
    int[] borderColor = new int[]{-1};
    boolean isBorderColor;
    boolean isTransparencyProcessing;

    public ExtJSRescaleOp(float[] scaleFactors, float[] offsets, RenderingHints hints) {
        this.length = scaleFactors.length;
        if (this.length > offsets.length) {
            this.length = offsets.length;
        }
        this.scaleFactors = new float[this.length];
        this.offsets = new float[this.length];
        int i = 0;
        while (i < this.length) {
            this.scaleFactors[i] = scaleFactors[i];
            this.offsets[i] = offsets[i];
            ++i;
        }
        this.hints = hints;
    }

    public ExtJSRescaleOp(float scaleFactor, float offset, RenderingHints hints) {
        this.length = 1;
        this.scaleFactors = new float[1];
        this.offsets = new float[1];
        this.scaleFactors[0] = scaleFactor;
        this.offsets[0] = offset;
        this.hints = hints;
    }

    public final float[] getScaleFactors(float[] scaleFactors) {
        if (scaleFactors == null) {
            return (float[])this.scaleFactors.clone();
        }
        System.arraycopy(this.scaleFactors, 0, scaleFactors, 0, Math.min(this.scaleFactors.length, scaleFactors.length));
        return scaleFactors;
    }

    public final float[] getOffsets(float[] offsets) {
        if (offsets == null) {
            return (float[])this.offsets.clone();
        }
        System.arraycopy(this.offsets, 0, offsets, 0, Math.min(this.offsets.length, offsets.length));
        return offsets;
    }

    public final int getNumFactors() {
        return this.length;
    }

    private ByteLookupTable createByteLut(float[] scale, float[] off, int nBands, int nElems) {
        byte[][] lutData = new byte[scale.length][nElems];
        int band = 0;
        while (band < scale.length) {
            float bandScale = scale[band];
            float bandOff = off[band];
            byte[] bandLutData = lutData[band];
            int i = 0;
            while (i < nElems) {
                int val = (int)((float)i * bandScale + bandOff);
                if ((val & 0xFFFFFF00) != 0) {
                    val = val < 0 ? 0 : 255;
                }
                bandLutData[i] = (byte)val;
                ++i;
            }
            ++band;
        }
        return new ByteLookupTable(0, lutData);
    }

    private ShortLookupTable createShortLut(float[] scale, float[] off, int nBands, int nElems) {
        short[][] lutData = new short[scale.length][nElems];
        int band = 0;
        while (band < scale.length) {
            float bandScale = scale[band];
            float bandOff = off[band];
            short[] bandLutData = lutData[band];
            int i = 0;
            while (i < nElems) {
                int val = (int)((float)i * bandScale + bandOff);
                if ((val & 0xFFFF0000) != 0) {
                    val = val < 0 ? 0 : 65535;
                }
                bandLutData[i] = (short)val;
                ++i;
            }
            ++band;
        }
        return new ShortLookupTable(0, lutData);
    }

    private boolean canUseLookup(Raster src, Raster dst) {
        int datatype = src.getDataBuffer().getDataType();
        if (datatype != 0 && datatype != 1) {
            return false;
        }
        SampleModel dstSM = dst.getSampleModel();
        this.dstNbits = dstSM.getSampleSize(0);
        if (this.dstNbits != 8 && this.dstNbits != 16) {
            return false;
        }
        int i = 1;
        while (i < src.getNumBands()) {
            int bandSize = dstSM.getSampleSize(i);
            if (bandSize != this.dstNbits) {
                return false;
            }
            ++i;
        }
        SampleModel srcSM = src.getSampleModel();
        this.srcNbits = srcSM.getSampleSize(0);
        if (this.srcNbits > 16) {
            return false;
        }
        int i2 = 1;
        while (i2 < src.getNumBands()) {
            int bandSize = srcSM.getSampleSize(i2);
            if (bandSize != this.srcNbits) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    @Override
    public final BufferedImage filter(BufferedImage src, BufferedImage dst) {
        ColorModel dstCM;
        ColorModel srcCM = src.getColorModel();
        int numBands = srcCM.getNumColorComponents();
        if (srcCM instanceof IndexColorModel) {
            IndexColorModel icm = (IndexColorModel)src.getColorModel();
            return new BufferedImage(this.rescale(icm, this.scaleFactors, this.offsets), src.getRaster(), false, null);
        }
        if (srcCM instanceof ComponentColorModel) {
            ComponentColorModel icm = (ComponentColorModel)src.getColorModel();
            return new BufferedImage(icm, this.rescaleCCM(this.scaleFactors, this.offsets, src), false, null);
        }
        if (this.length != 1 && this.length != numBands && this.length != srcCM.getNumComponents()) {
            throw new IllegalArgumentException("Number of scaling constants does not equal the number of of color or color/alpha  components");
        }
        boolean needToConvert = false;
        if (this.length > numBands && srcCM.hasAlpha()) {
            this.length = numBands + 1;
        }
        int width = src.getWidth();
        int height = src.getHeight();
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, null);
            dstCM = srcCM;
        } else {
            if (width != dst.getWidth()) {
                throw new IllegalArgumentException("Src width (" + width + ") not equal to dst width (" + dst.getWidth() + ")");
            }
            if (height != dst.getHeight()) {
                throw new IllegalArgumentException("Src height (" + height + ") not equal to dst height (" + dst.getHeight() + ")");
            }
            dstCM = dst.getColorModel();
            if (srcCM.getColorSpace().getType() != dstCM.getColorSpace().getType()) {
                needToConvert = true;
                dst = this.createCompatibleDestImage(src, null);
            }
        }
        BufferedImage origDst = dst;
        if (this.filter(src, dst) == null) {
            int dstNumBands;
            WritableRaster srcRaster = src.getRaster();
            WritableRaster dstRaster = dst.getRaster();
            if (srcCM.hasAlpha() && (numBands - 1 == this.length || this.length == 1)) {
                int minx = srcRaster.getMinX();
                int miny = srcRaster.getMinY();
                int[] bands = new int[numBands - 1];
                int i = 0;
                while (i < numBands - 1) {
                    bands[i] = i;
                    ++i;
                }
                srcRaster = srcRaster.createWritableChild(minx, miny, srcRaster.getWidth(), srcRaster.getHeight(), minx, miny, bands);
            }
            if (dstCM.hasAlpha() && ((dstNumBands = dstRaster.getNumBands()) - 1 == this.length || this.length == 1)) {
                int minx = dstRaster.getMinX();
                int miny = dstRaster.getMinY();
                int[] bands = new int[numBands - 1];
                int i = 0;
                while (i < numBands - 1) {
                    bands[i] = i;
                    ++i;
                }
                dstRaster = dstRaster.createWritableChild(minx, miny, dstRaster.getWidth(), dstRaster.getHeight(), minx, miny, bands);
            }
            this.filter(srcRaster, dstRaster);
        }
        if (needToConvert) {
            ColorConvertOp ccop = new ColorConvertOp(this.hints);
            ccop.filter(dst, origDst);
        }
        return origDst;
    }

    @Override
    public final WritableRaster filter(Raster src, WritableRaster dst) {
        int numBands = src.getNumBands();
        int width = src.getWidth();
        int height = src.getHeight();
        int[] srcPix = null;
        int step = 0;
        int tidx = 0;
        if (dst == null) {
            dst = this.createCompatibleDestRaster(src);
        } else {
            if (height != dst.getHeight() || width != dst.getWidth()) {
                throw new IllegalArgumentException("Width or height of Rasters do not match");
            }
            if (numBands != dst.getNumBands()) {
                throw new IllegalArgumentException("Number of bands in src " + numBands + " does not equal number of bands in dest " + dst.getNumBands());
            }
        }
        if (this.length != 1 && this.length != src.getNumBands()) {
            throw new IllegalArgumentException("Number of scaling constants does not equal the number of of bands in the src raster");
        }
        if (this.canUseLookup(src, dst)) {
            int srcNgray = 1 << this.srcNbits;
            int dstNgray = 1 << this.dstNbits;
            if (dstNgray == 256) {
                ByteLookupTable lut = this.createByteLut(this.scaleFactors, this.offsets, numBands, srcNgray);
                LookupOp op = new LookupOp(lut, this.hints);
                op.filter(src, dst);
            } else {
                ShortLookupTable lut = this.createShortLut(this.scaleFactors, this.offsets, numBands, srcNgray);
                LookupOp op = new LookupOp(lut, this.hints);
                op.filter(src, dst);
            }
        } else {
            if (this.length > 1) {
                step = 1;
            }
            int sminX = src.getMinX();
            int sY = src.getMinY();
            int dminX = dst.getMinX();
            int dY = dst.getMinY();
            int[] dstMax = new int[numBands];
            int[] dstMask = new int[numBands];
            SampleModel dstSM = dst.getSampleModel();
            int z = 0;
            while (z < numBands) {
                int nbits = dstSM.getSampleSize(z);
                dstMax[z] = (1 << nbits) - 1;
                dstMask[z] = ~dstMax[z];
                ++z;
            }
            int y = 0;
            while (y < height) {
                int dX = dminX;
                int sX = sminX;
                int x = 0;
                while (x < width) {
                    srcPix = src.getPixel(sX, sY, srcPix);
                    tidx = 0;
                    int z2 = 0;
                    while (z2 < numBands) {
                        int val = (int)((float)srcPix[z2] * this.scaleFactors[tidx] + this.offsets[tidx]);
                        if ((val & dstMask[z2]) != 0) {
                            val = val < 0 ? 0 : dstMax[z2];
                        }
                        srcPix[z2] = val;
                        ++z2;
                        tidx += step;
                    }
                    dst.setPixel(dX, dY, srcPix);
                    ++x;
                    ++sX;
                    ++dX;
                }
                ++y;
                ++sY;
                ++dY;
            }
        }
        return dst;
    }

    @Override
    public final Rectangle2D getBounds2D(BufferedImage src) {
        return this.getBounds2D(src.getRaster());
    }

    @Override
    public final Rectangle2D getBounds2D(Raster src) {
        return src.getBounds();
    }

    @Override
    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel destCM) {
        BufferedImage image;
        if (destCM == null) {
            ColorModel cm = src.getColorModel();
            image = new BufferedImage(cm, src.getRaster().createCompatibleWritableRaster(), cm.isAlphaPremultiplied(), null);
        } else {
            int w = src.getWidth();
            int h = src.getHeight();
            image = new BufferedImage(destCM, destCM.createCompatibleWritableRaster(w, h), destCM.isAlphaPremultiplied(), null);
        }
        return image;
    }

    @Override
    public WritableRaster createCompatibleDestRaster(Raster src) {
        return src.createCompatibleWritableRaster(src.getWidth(), src.getHeight());
    }

    @Override
    public final Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        if (dstPt == null) {
            dstPt = new Point2D.Float();
        }
        dstPt.setLocation(srcPt.getX(), srcPt.getY());
        return dstPt;
    }

    @Override
    public final RenderingHints getRenderingHints() {
        return this.hints;
    }

    public void rescale(byte[] compsR, byte[] compsG, byte[] compsB, byte[] compsA, float[] scaleFactor, float[] offset, int[] borderColor, float[] borderOffset) {
        int i = 0;
        while (i < compsR.length) {
            int newCompR;
            float localOffsetR = offset[0];
            float localOffsetG = offset[1];
            float localOffsetB = offset[2];
            int compR = 0xFF & compsR[i];
            int compG = 0xFF & compsG[i];
            int compB = 0xFF & compsB[i];
            int comp = compR << 16 & 0xFF0000 | compG << 8 & 0xFF00 | compB & 0xFF;
            boolean isNeedChangeAlpha = true;
            if (this.isBorderColor && (borderOffset[0] != 0.0f || borderOffset[1] != 0.0f || borderOffset[2] != 0.0f) && Arrays.binarySearch(borderColor, comp) >= 0) {
                if (!this.isTransparencyProcessing) {
                    localOffsetR = borderOffset[0];
                    localOffsetG = borderOffset[1];
                    localOffsetB = borderOffset[2];
                } else {
                    isNeedChangeAlpha = false;
                    localOffsetR = 0.0f;
                    localOffsetG = 0.0f;
                    localOffsetB = 0.0f;
                }
            }
            if ((newCompR = Math.round((float)compR * scaleFactor[0] + localOffsetR)) < 0) {
                newCompR = 0;
            } else if (newCompR > 255) {
                newCompR = 255;
            }
            compsR[i] = (byte)newCompR;
            int newCompG = Math.round((float)compG * scaleFactor[1] + localOffsetG);
            if (newCompG < 0) {
                newCompG = 0;
            } else if (newCompG > 255) {
                newCompG = 255;
            }
            compsG[i] = (byte)newCompG;
            int newCompB = Math.round((float)compB * scaleFactor[2] + localOffsetB);
            if (newCompB < 0) {
                newCompB = 0;
            } else if (newCompB > 255) {
                newCompB = 255;
            }
            compsB[i] = (byte)newCompB;
            if (isNeedChangeAlpha && compsA != null) {
                int newCompA = Math.round((float)(0xFF & compsA[i]) * scaleFactor[3] + offset[3]);
                if (newCompA < 0) {
                    newCompA = 0;
                } else if (newCompA > 255) {
                    newCompA = 255;
                }
                compsA[i] = (byte)newCompA;
            }
            ++i;
        }
    }

    public IndexColorModel rescale(IndexColorModel icm, float[] scaleFactor, float[] offset) {
        int size = icm.getMapSize();
        byte[] reds = new byte[size];
        byte[] greens = new byte[size];
        byte[] blues = new byte[size];
        byte[] alphas = new byte[size];
        icm.getReds(reds);
        icm.getGreens(greens);
        icm.getBlues(blues);
        icm.getAlphas(alphas);
        this.rescale(reds, greens, blues, alphas, scaleFactor, offset, this.borderColor, this.borderOffsets);
        return new IndexColorModel(8, size, reds, greens, blues, alphas);
    }

    public WritableRaster rescaleCCM(float[] scaleFactor, float[] offset, BufferedImage src) {
        int width = src.getWidth();
        int height = src.getHeight();
        int size = width * height;
        byte[] r = new byte[size];
        byte[] g = new byte[size];
        byte[] b = new byte[size];
        byte[] a = new byte[size];
        Raster raster = src.getData();
        DataBuffer dataBuffer = raster.getDataBuffer();
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                int pixel = x + y * width;
                int index = 4 * pixel;
                r[pixel] = (byte)dataBuffer.getElem(index);
                g[pixel] = (byte)dataBuffer.getElem(index + 1);
                b[pixel] = (byte)dataBuffer.getElem(index + 2);
                a[pixel] = (byte)dataBuffer.getElem(index + 3);
                ++x;
            }
            ++y;
        }
        this.rescale(r, g, b, a, scaleFactor, offset, this.borderColor, this.borderOffsets);
        ColorSpace cs = ColorSpace.getInstance(1000);
        int[] bits = new int[]{8, 8, 8, 8};
        ComponentColorModel cm = new ComponentColorModel(cs, bits, true, false, 1, 0);
        WritableRaster wr = ((ColorModel)cm).createCompatibleWritableRaster(src.getWidth(), src.getHeight());
        DataBufferByte dbf = (DataBufferByte)wr.getDataBuffer();
        byte[] data = dbf.getData();
        int i = 0;
        while (i < size) {
            int pix = i * 4;
            data[pix] = r[i];
            data[pix + 1] = g[i];
            data[pix + 2] = b[i];
            data[pix + 3] = a[i];
            ++i;
        }
        return wr;
    }

    public BufferedImage filter(BufferedImage image, BufferedImage dst, float[] borderOffsets, int[] borderColor, boolean isBorderColor, boolean isTransparencyProcessing) {
        this.borderOffsets = borderOffsets;
        this.borderColor = borderColor;
        this.isBorderColor = isBorderColor;
        this.isTransparencyProcessing = isTransparencyProcessing;
        BufferedImage result = this.filter(image, dst);
        this.borderOffsets = null;
        this.borderColor = new int[]{-1};
        this.isBorderColor = false;
        this.isTransparencyProcessing = false;
        return result;
    }
}

