/*
 * Decompiled with CFR 0.152.
 */
package cesium.factory;

import cesium.factory.ResourcesLoaderFactory;
import cesium.holder.GIFHolderImpl;
import cesium.holder.PNGHolderImpl;
import cesium.holder.PSDHolderImpl;
import cesium.holder.ResourcesHolder;
import cesium.loader.AbstractResourcesLoader;
import cesium.loader.GIFResourceLoaderImpl;
import cesium.loader.PNGResourceLoaderImpl;
import cesium.loader.PSDResourceLoaderImpl;
import cesium.loader.ResourcesLoader;
import cesium.loader.SchemaResourcesLoaderImpl;

public class ResourcesLoaderFactoryImpl
implements ResourcesLoaderFactory {
    static String css_ext = ".css";
    static String gif_ext = ".gif";
    static String psd_ext = ".psd";
    static String png_ext = ".png";

    @Override
    public boolean isValidResourceFileName(String fileName) {
        return this.isValidCSSFileName(fileName) || this.isValidGIFFileName(fileName) || this.isValidPNGFileName(fileName);
    }

    @Override
    public boolean isValidCSSFileName(String name) {
        return name.endsWith(css_ext);
    }

    @Override
    public boolean isValidGIFFileName(String name) {
        return name.endsWith(gif_ext);
    }

    @Override
    public boolean isValidPNGFileName(String name) {
        return name.endsWith(png_ext);
    }

    @Override
    public boolean isValidPSDFileName(String name) {
        return name.endsWith(psd_ext);
    }

    @Override
    public ResourcesLoader getResourcesLoader(String resourcesPath) {
        AbstractResourcesLoader result = null;
        result = this.isValidGIFFileName(resourcesPath) ? new GIFResourceLoaderImpl() : (this.isValidPNGFileName(resourcesPath) ? new PNGResourceLoaderImpl() : (this.isValidPSDFileName(resourcesPath) ? new PSDResourceLoaderImpl() : new SchemaResourcesLoaderImpl()));
        return result;
    }

    @Override
    public ResourcesLoader getResourcesLoader(ResourcesHolder holder) {
        AbstractResourcesLoader result = null;
        result = holder instanceof GIFHolderImpl ? new GIFResourceLoaderImpl() : (holder instanceof PNGHolderImpl ? new PNGResourceLoaderImpl() : (holder instanceof PSDHolderImpl ? new PSDResourceLoaderImpl() : new SchemaResourcesLoaderImpl()));
        return result;
    }
}

