/*
 * Decompiled with CFR 0.152.
 */
package br.com.senior.portaria.udiagtreeview;

import br.com.senior.asas.classes.TComponent;
import br.com.senior.asas.classes.TComponentStateEnum;
import br.com.senior.asas.classes.TFileStream;
import br.com.senior.asas.classes.TShiftStateEnum;
import br.com.senior.asas.classes.TStream;
import br.com.senior.asas.comctrls.THitTest;
import br.com.senior.asas.comctrls.TTreeNode;
import br.com.senior.asas.comctrls.TTreeView;
import br.com.senior.asas.commctrl.TTVItem;
import br.com.senior.asas.controls.TMouseButton;
import br.com.senior.asas.sys.IMessage;
import br.com.senior.asas.sys.SetOf;
import br.com.senior.asas.sys.Sys;
import br.com.senior.asas.sys.TClass;
import br.com.senior.asas.sys.TInt;
import br.com.senior.asas.sys.VarInt;
import br.com.senior.asas.sysutils.SysUtils;
import br.com.senior.asas.typinfo.Property;
import br.com.senior.asas.windows.TPoint;
import br.com.senior.asas.windows.USER32Api;
import br.com.senior.portaria.udiagtreeview.TDiagTreeViewClass;

public class TDiagTreeView
extends TTreeView {
    private boolean fStateRecursion;
    private int fStateIgnore;

    private final void propogateStateDown(TTreeNode node) {
        if (node.getStateIndex() == this.fStateIgnore) {
            return;
        }
        TTreeNode child = node.getFirstChild();
        while (child != null) {
            if (child.getStateIndex() != node.getStateIndex()) {
                if (child.getStateIndex() != this.fStateIgnore) {
                    child.setStateIndex(node.getStateIndex());
                }
                this.propogateStateDown(child);
            }
            child = node.getNextChild(child);
        }
    }

    private final void propogateStateUp(TTreeNode node) {
        if (node.getStateIndex() == this.fStateIgnore) {
            return;
        }
        int flag = 0;
        TTreeNode child = node.getFirstChild();
        while (child != null) {
            switch (child.getStateIndex()) {
                case -1: {
                    flag |= 1;
                    break;
                }
                case 1: {
                    flag |= 1;
                    break;
                }
                case 2: {
                    flag |= 2;
                    break;
                }
                case 3: {
                    flag |= 4;
                }
            }
            child = node.getNextChild(child);
        }
        switch (flag) {
            case 1: {
                node.setStateIndex(1);
                break;
            }
            case 2: {
                node.setStateIndex(2);
                break;
            }
            default: {
                node.setStateIndex(3);
            }
        }
        if (node.getParent() != null) {
            this.propogateStateUp(node.getParent());
        }
    }

    private final void stateSaveToStream(TTreeNode node, TStream stream) {
        while (node != null) {
            int state = node.getStateIndex();
            stream.write(state, Sys.sizeOf((int)state));
            if (state == this.getStateIgnore()) {
                return;
            }
            TTreeNode child = node.getFirstChild();
            while (child != null) {
                this.stateSaveToStream(child, stream);
                child = node.getNextChild(child);
            }
            node = node.getNextSibling();
        }
    }

    private final void stateLoadFromStream(TTreeNode node, TStream stream) {
        TInt state = new TInt();
        while (node != null) {
            stream.read((VarInt)state, Sys.sizeOf((int)state.v));
            if (state.v == this.getStateIgnore()) {
                return;
            }
            node.setStateIndex(state.v);
            TTreeNode child = node.getFirstChild();
            while (child != null) {
                this.stateLoadFromStream(child, stream);
                child = node.getNextChild(child);
            }
            node = node.getNextSibling();
        }
    }

    public final void setStateIgnore(int value) {
        this.fStateIgnore = value;
    }

    protected void propogateState(TTreeNode node) {
        this.fStateRecursion = false;
        try {
            this.propogateStateDown(node);
            if (node.getParent() != null) {
                this.propogateStateUp(node.getParent());
            }
        }
        finally {
            this.fStateRecursion = true;
        }
    }

    protected void syncState(TTreeNode node) {
        while (node != null) {
            if (node.getStateIndex() != this.fStateIgnore) {
                if (node.getStateIndex() == 2) {
                    this.propogateState(node);
                } else {
                    if (node.getStateIndex() == -1) {
                        this.fStateRecursion = false;
                        node.setStateIndex(1);
                        this.fStateRecursion = true;
                    }
                    TTreeNode child = node.getFirstChild();
                    while (child != null) {
                        if (child.getStateIndex() != this.fStateIgnore) {
                            this.syncState(child);
                        }
                        child = node.getNextChild(child);
                    }
                }
            }
            node = node.getNextSibling();
        }
    }

    public void setStateRecursion(boolean value) {
        if (value != this.fStateRecursion) {
            this.fStateRecursion = value;
            if (value) {
                this.syncState(this.getItems().getFirstNode());
            }
        }
    }

    public void wndProc(IMessage message) {
        super.wndProc(message);
        if (!SetOf.intersection((SetOf[])new SetOf[]{SetOf.create((Enum[])new TComponentStateEnum[]{TComponentStateEnum.csDesigning, TComponentStateEnum.csLoading, TComponentStateEnum.csReading}), this.getComponentState()}).isEmpty()) {
            return;
        }
        if (!this.fStateRecursion) {
            return;
        }
        if (message.getMsg() == 4365) {
            TTVItem item = new TTVItem(Sys.toPtr((int)message.getLParam()), 0);
            if ((Sys.unsigned((int)item.mask) & 0x18L) > 0L) {
                TTreeNode node = this.getItems().getNode(item.hItem);
                if (SetOf.create((byte[])new byte[]{1, 2}).contains((Object)node.getStateIndex())) {
                    this.nodeStateChangeNotify(node);
                }
            }
        }
    }

    protected void loaded() {
        super.loaded();
        if (this.getComponentState().contains((Object)TComponentStateEnum.csDesigning)) {
            return;
        }
        if (this.fStateRecursion) {
            this.syncState(this.getItems().getFirstNode());
        }
    }

    protected void nodeStateChangeNotify(TTreeNode node) {
        this.propogateState(node);
    }

    protected void mouseDown(TMouseButton button, SetOf<TShiftStateEnum> shift, int x, int y) {
        super.mouseDown(button, shift, x, y);
        if (!this.fStateRecursion) {
            return;
        }
        if (this.getSelected() != null && this.getHitTestInfoAt(x, y).contains((Object)THitTest.htOnStateIcon)) {
            int index = this.getSelected().getStateIndex();
            if (++index > 2) {
                index = 1;
            }
            this.getSelected().setStateIndex(index);
        }
    }

    public static TDiagTreeView create(TComponent aOwner) {
        TDiagTreeView result = new TDiagTreeView();
        try {
            result.runCreate(aOwner);
            result.afterConstruction();
            return result;
        }
        catch (Throwable e) {
            result.destroy();
            throw Sys.wrap((Throwable)e);
        }
    }

    protected void runDestroy() {
        super.runDestroy();
    }

    public void statesSaveToStream(TStream stream) {
        this.stateSaveToStream(this.getItems().getFirstNode(), stream);
    }

    public void statesLoadFromStream(TStream stream) {
        this.stateLoadFromStream(this.getItems().getFirstNode(), stream);
    }

    public final void statesSaveToFile(String filename) {
        TFileStream stream = TFileStream.create((String)filename, (int)-1);
        try {
            this.statesSaveToStream((TStream)stream);
        }
        finally {
            stream = (TFileStream)SysUtils.freeAndNil((Object)stream);
        }
    }

    public final void statesLoadFromFile(String filename) {
        TFileStream stream = TFileStream.create((String)filename, (int)64);
        try {
            this.statesLoadFromStream((TStream)stream);
        }
        finally {
            stream = (TFileStream)SysUtils.freeAndNil((Object)stream);
        }
    }

    public final boolean mouseOnStateImage() {
        TPoint mousePos = new TPoint();
        USER32Api.GetCursorPos((TPoint)mousePos);
        mousePos.assign(this.screenToClient(mousePos));
        return this.getHitTestInfoAt(mousePos.x, mousePos.y).contains((Object)THitTest.htOnStateIcon);
    }

    @Property(name="StateRecursion")
    public final boolean getStateRecursion() {
        return this.fStateRecursion;
    }

    @Property(name="StateIgnore")
    public final int getStateIgnore() {
        return this.fStateIgnore;
    }

    public static TDiagTreeView createParented(int parentWindow) {
        TDiagTreeView result = new TDiagTreeView();
        try {
            result.runCreateParented(parentWindow);
            result.afterConstruction();
            return result;
        }
        catch (Throwable e) {
            result.destroy();
            throw Sys.wrap((Throwable)e);
        }
    }

    public static TDiagTreeViewClass classOf() {
        return (TDiagTreeViewClass)((Object)TClass.getInstance(TDiagTreeView.class));
    }

    public TDiagTreeViewClass classType() {
        return TDiagTreeView.classOf();
    }
}

