/*
 * Decompiled with CFR 0.152.
 */
package br.com.senior.portaria.rhparser;

import br.com.senior.asas.rtstringtranslator.RtStringTranslator;
import br.com.senior.asas.sys.PChar;
import br.com.senior.asas.sys.ReadablePChar;
import br.com.senior.asas.sys.SetOf;
import br.com.senior.asas.sys.Sys;
import br.com.senior.asas.sys.TClass;
import br.com.senior.asas.sys.TObject;
import br.com.senior.asas.sys.WriteablePChar;
import br.com.senior.asas.sysutils.SysUtils;
import br.com.senior.portaria.rhparser.ECompile;
import br.com.senior.portaria.rhparser.TToken;
import br.com.senior.portaria.rhparser.TTokenType;
import br.com.senior.portaria.rhparser.rhparser;

public class TParser
extends TObject {
    private char[] fSource = null;
    private int fCurLine;
    private PChar fCurChar;
    private static final SetOf<Character> iIdentifier_cStopSymbols = SetOf.create((char[])new char[]{'+', '-', '*', '/', '(', ')', '[', ']', '{', '}', ':', ';', '\'', '\"', ',', '<', '>', '=', '@', ' ', '\r', '\n'});

    private final void iSetSource(String aValue) {
        this.fSource = Sys.chars((String)aValue);
        this.fSource = Sys.uniqueString((char[])this.fSource);
        this.fCurChar = Sys.getPChar((char[])this.fSource);
        this.fCurLine = 1;
    }

    private final String iLineBreak(PChar aCurChar) {
        PChar xBegin = (PChar)Sys.copy((ReadablePChar)aCurChar);
        while (aCurChar.get() == '\r') {
            ++this.fCurLine;
            aCurChar.inc();
            if (aCurChar.get() != '\n') continue;
            aCurChar.inc();
        }
        String result = Sys.setString((ReadablePChar)Sys.copy((ReadablePChar)xBegin), (int)aCurChar.offsetFrom((ReadablePChar)xBegin));
        return result;
    }

    private final String iSkipSpaces(PChar aCurChar) {
        PChar xBegin = (PChar)Sys.copy((ReadablePChar)aCurChar);
        while (aCurChar.get() == ' ' || aCurChar.get() == '\t') {
            aCurChar.inc();
        }
        String result = Sys.setString((ReadablePChar)Sys.copy((ReadablePChar)xBegin), (int)aCurChar.offsetFrom((ReadablePChar)xBegin));
        return result;
    }

    private final String iSkipLineComment(PChar aCurChar) {
        PChar xBegin = (PChar)Sys.copy((ReadablePChar)aCurChar);
        aCurChar.inc();
        while (aCurChar.get() != '@') {
            aCurChar.inc();
        }
        aCurChar.inc();
        String result = Sys.setString((ReadablePChar)Sys.copy((ReadablePChar)xBegin), (int)aCurChar.offsetFrom((ReadablePChar)xBegin));
        return result;
    }

    private final String iSkipBlockComment(PChar aCurChar) {
        PChar xBegin = (PChar)Sys.copy((ReadablePChar)aCurChar);
        aCurChar.inc(2);
        while (SysUtils.strLIComp((ReadablePChar)Sys.copy((ReadablePChar)aCurChar), (ReadablePChar)Sys.getPChar((String)"*/"), (int)2) != 0) {
            aCurChar.inc();
        }
        aCurChar.inc(2);
        String result = Sys.setString((ReadablePChar)Sys.copy((ReadablePChar)xBegin), (int)aCurChar.offsetFrom((ReadablePChar)xBegin));
        return result;
    }

    private final TToken iIdentifier(PChar aCurChar) {
        PChar xIdentBegin = (PChar)Sys.copy((ReadablePChar)aCurChar);
        while (!iIdentifier_cStopSymbols.contains((Object)Character.valueOf(aCurChar.get()))) {
            aCurChar.inc();
        }
        int xIdentSize = aCurChar.offsetFrom((ReadablePChar)xIdentBegin);
        char[] xIdent = null;
        xIdent = Sys.setLength(xIdent, (int)xIdentSize);
        SysUtils.strLCopy((WriteablePChar)Sys.getPChar((char[])xIdent), (ReadablePChar)Sys.copy((ReadablePChar)xIdentBegin), (int)xIdentSize);
        int iStop = Sys.high((Object[])rhparser.cReservedWords, (int)1);
        TToken result = new TToken();
        for (int i = Sys.low((Object[])rhparser.cReservedWords, (int)1); i <= iStop; ++i) {
            if (SysUtils.strIComp((String)Sys.toStr((char[])xIdent), (String)Sys.toStr((char[])rhparser.cReservedWords[i - 1].rValue)) != 0) continue;
            result.rType = rhparser.cReservedWords[i - 1].rType;
            result.rValue = Sys.chars((String)Sys.toStr((char[])xIdent));
            return result;
        }
        result.rType = TTokenType.ttIdentifier;
        result.rValue = Sys.chars((String)Sys.toStr((char[])xIdent));
        return result;
    }

    private final TToken iSymbol(PChar aCurChar) {
        int iStop = Sys.high((Object[])rhparser.cSymbols, (int)1);
        TToken result = new TToken();
        for (int i = Sys.low((Object[])rhparser.cSymbols, (int)1); i <= iStop; ++i) {
            String xValue = Sys.toStr((char[])rhparser.cSymbols[i - 1].rValue);
            int xValueLength = Sys.length((CharSequence)xValue);
            if (SysUtils.strLIComp((ReadablePChar)Sys.copy((ReadablePChar)aCurChar), (ReadablePChar)Sys.getPChar((String)xValue), (int)xValueLength) != 0) continue;
            result.assign(rhparser.cSymbols[i - 1]);
            aCurChar.inc(xValueLength);
            return result;
        }
        throw ECompile.createFmt(RtStringTranslator.transStr((String)"VT6776", (String)"S\u00edmbolo inv\u00e1lido: '%s'", (boolean)true), Character.valueOf(aCurChar.get()));
    }

    private final TToken iStringLiteral(PChar aCurChar) {
        PChar xBegin = (PChar)Sys.copy((ReadablePChar)aCurChar);
        aCurChar.inc();
        while (aCurChar.get() != '\"') {
            if (aCurChar.get() == '\\') {
                aCurChar.inc();
                if (this.fCurChar.get() == '\r') {
                    this.iLineBreak((PChar)Sys.copy((ReadablePChar)aCurChar));
                }
            }
            aCurChar.inc();
        }
        aCurChar.inc();
        TToken result = new TToken();
        result.rType = TTokenType.ttStringLiteral;
        result.rValue = Sys.setString((ReadablePChar)Sys.copy((ReadablePChar)xBegin), (int)aCurChar.offsetFrom((ReadablePChar)xBegin)).toCharArray();
        return result;
    }

    private final TToken iCharLiteral(PChar aCurChar) {
        PChar xBegin = (PChar)Sys.copy((ReadablePChar)aCurChar);
        aCurChar.inc();
        aCurChar.inc();
        if (aCurChar.get() != '\'') {
            throw ECompile.create(RtStringTranslator.transStr((String)"VT6777", (String)"Defini\u00e7\u00e3o de caracter inv\u00e1lido", (boolean)true));
        }
        aCurChar.inc();
        TToken result = new TToken();
        result.rType = TTokenType.ttCharLiteral;
        result.rValue = Sys.setString((ReadablePChar)Sys.copy((ReadablePChar)xBegin), (int)aCurChar.offsetFrom((ReadablePChar)xBegin)).toCharArray();
        return result;
    }

    private final TToken iNumberLiteral(PChar aCurChar) {
        String xValue = "";
        do {
            xValue = xValue + aCurChar.get();
            aCurChar.inc();
        } while (rhparser.cDigits.contains((Object)Character.valueOf(aCurChar.get())));
        TToken result = new TToken();
        if (aCurChar.get() == '.') {
            do {
                xValue = xValue + aCurChar.get();
                aCurChar.inc();
            } while (rhparser.cDigits.contains((Object)Character.valueOf(aCurChar.get())));
            result.rType = TTokenType.ttFloatLiteral;
        } else {
            result.rType = TTokenType.ttIntegerLiteral;
        }
        result.rValue = Sys.chars((String)xValue);
        return result;
    }

    public final TToken nextToken() {
        String xPreValue;
        TToken result;
        block15: {
            result = new TToken();
            xPreValue = "";
            while (true) {
                if (this.fCurChar.get() == '\u0000') {
                    result.rType = TTokenType.ttEOF;
                    result.rValue = Sys.chars((String)"");
                    break block15;
                }
                if (this.fCurChar.get() == '\r') {
                    xPreValue = xPreValue + this.iLineBreak((PChar)Sys.copy((ReadablePChar)this.fCurChar));
                    continue;
                }
                if (SetOf.create((char[])new char[]{' ', '\t'}).contains((Object)Character.valueOf(this.fCurChar.get()))) {
                    xPreValue = xPreValue + this.iSkipSpaces((PChar)Sys.copy((ReadablePChar)this.fCurChar));
                    continue;
                }
                if (this.fCurChar.get() == '@') {
                    xPreValue = xPreValue + this.iSkipLineComment((PChar)Sys.copy((ReadablePChar)this.fCurChar));
                    continue;
                }
                if (SysUtils.strLIComp((ReadablePChar)Sys.copy((ReadablePChar)this.fCurChar), (ReadablePChar)Sys.getPChar((String)"/*"), (int)2) != 0) break;
                xPreValue = xPreValue + this.iSkipBlockComment((PChar)Sys.copy((ReadablePChar)this.fCurChar));
            }
            if (rhparser.cAlpha.contains((Object)Character.valueOf(this.fCurChar.get()))) {
                result.assign(this.iIdentifier((PChar)Sys.copy((ReadablePChar)this.fCurChar)));
            } else if (rhparser.cStartSymbols.contains((Object)Character.valueOf(this.fCurChar.get()))) {
                result.assign(this.iSymbol((PChar)Sys.copy((ReadablePChar)this.fCurChar)));
            } else if (this.fCurChar.get() == '\"') {
                result.assign(this.iStringLiteral((PChar)Sys.copy((ReadablePChar)this.fCurChar)));
            } else if (this.fCurChar.get() == '\'') {
                result.assign(this.iCharLiteral((PChar)Sys.copy((ReadablePChar)this.fCurChar)));
            } else if (rhparser.cDigits.contains((Object)Character.valueOf(this.fCurChar.get()))) {
                result.assign(this.iNumberLiteral((PChar)Sys.copy((ReadablePChar)this.fCurChar)));
            } else {
                throw ECompile.createFmt(RtStringTranslator.transStr((String)"VT6778", (String)"Caracter inv\u00e1lido na entrada de dados: '%s' ($%x)", (boolean)true), Character.valueOf(this.fCurChar.get()), Sys.ord((char)this.fCurChar.get()));
            }
        }
        result.rPreValue = xPreValue;
        return result;
    }

    public final TToken previewToken() {
        PChar xCurChar = (PChar)Sys.copy((ReadablePChar)this.fCurChar);
        TToken result = new TToken();
        result.assign(this.nextToken());
        this.fCurChar = (PChar)Sys.copy((ReadablePChar)xCurChar);
        return result;
    }

    public final String getSource() {
        return Sys.toStr((char[])this.fSource);
    }

    public final void setSource(String value) {
        this.iSetSource(value);
    }

    public static TParser create() {
        TParser result = new TParser();
        try {
            result.runCreate();
            result.afterConstruction();
            return result;
        }
        catch (Throwable e) {
            result.destroy();
            throw Sys.wrap((Throwable)e);
        }
    }

    public static TClass classOf() {
        return (TClass)TClass.getInstance(TParser.class);
    }

    public TClass classType() {
        return TParser.classOf();
    }
}

